% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07_Biclustering.R, R/15_NominalBiclustering.R,
%   R/16_OrdinalBiclustering.R
\name{Biclustering}
\alias{Biclustering}
\alias{Biclustering.default}
\alias{Biclustering.binary}
\alias{Biclustering.nominal}
\alias{Biclustering.ordinal}
\title{Biclustering and Ranklustering Analysis}
\usage{
Biclustering(U, ...)

\method{Biclustering}{default}(U, na = NULL, Z = NULL, w = NULL, ...)

\method{Biclustering}{binary}(
  U,
  ncls = 2,
  nfld = 2,
  method = "B",
  conf = NULL,
  mic = FALSE,
  maxiter = 100,
  verbose = TRUE,
  ...
)

\method{Biclustering}{nominal}(
  U,
  ncls = 2,
  nfld = 2,
  conf = NULL,
  mic = FALSE,
  maxiter = 100,
  verbose = TRUE,
  ...
)

\method{Biclustering}{ordinal}(
  U,
  ncls = 2,
  nfld = 2,
  method = "B",
  conf = NULL,
  mic = FALSE,
  maxiter = 100,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{U}{Either an object of class "exametrika" or raw data. When raw data is given,
it is converted to the exametrika class with the \code{\link{dataFormat}} function.}

\item{...}{Additional arguments passed to specific methods.}

\item{na}{Values to be treated as missing values.}

\item{Z}{Missing indicator matrix of type matrix or data.frame. Values of 1 indicate
observed responses, while 0 indicates missing data.}

\item{w}{Item weight vector specifying the relative importance of each item.}

\item{ncls}{Number of latent classes/ranks to identify (between 2 and 20).}

\item{nfld}{Number of latent fields (item clusters) to identify.}

\item{method}{Analysis method to use (character string):
\itemize{
\item "B" or "Biclustering": Standard biclustering (default)
\item "R" or "Ranklustering": Ranklustering with ordered class structure
}}

\item{conf}{Confirmatory parameter for pre-specified field assignments. Can be either:
\itemize{
\item A vector with items and corresponding fields in sequence
\item A field membership profile matrix (items × fields) with 0/1 values
\item NULL (default) for exploratory analysis where field memberships are estimated
}}

\item{mic}{Logical; if TRUE, forces Field Reference Profiles to be monotonically
increasing. Default is FALSE.}

\item{maxiter}{Maximum number of EM algorithm iterations. Default is 100.}

\item{verbose}{Logical; if TRUE, displays progress during estimation. Default is TRUE.}
}
\value{
An object of class "exametrika" and "Biclustering" containing:
\describe{
\item{model}{Model type indicator (1 for biclustering, 2 for ranklustering)}
\item{msg}{A character string indicating the model type. }
\item{mic}{Logical value indicating whether monotonicity constraint was applied}
\item{testlength}{Number of items in the test}
\item{nobs}{Number of examinees in the dataset}
\item{Nclass}{Number of latent classes/ranks specified}
\item{Nfield}{Number of latent fields specified}
\item{N_Cycle}{Number of EM iterations performed}
\item{LFD}{Latent Field Distribution - counts of items assigned to each field}
\item{LRD/LCD}{Latent Rank/Class Distribution - counts of examinees assigned to each class/rank}
\item{FRP}{Field Reference Profile matrix - probability of correct response for each field-class combination}
\item{FRPIndex}{Field Reference Profile indices including location parameters, slope parameters, and monotonicity indices}
\item{TRP}{Test Reference Profile - expected score for examinees in each class/rank}
\item{CMD/RMD}{Class/Rank Membership Distribution - sum of membership probabilities across examinees}
\item{FieldMembership}{Matrix showing the probabilities of each item belonging to each field}
\item{ClassMembership}{Matrix showing the probabilities of each examinee belonging to each class/rank}
\item{SmoothedMembership}{Matrix of smoothed class membership probabilities after filtering}
\item{FieldEstimated}{Vector of the most likely field assignments for each item}
\item{ClassEstimated}{Vector of the most likely class/rank assignments for each examinee}
\item{Students}{Data frame containing membership probabilities and classification information for each examinee}
\item{FieldAnalysis}{Matrix showing field analysis results with item-level information}
\item{TestFitIndices}{Model fit indices for evaluating the quality of the clustering solution}
\item{SOACflg}{Logical flag indicating whether Strongly Ordinal Alignment Condition is satisfied}
\item{WOACflg}{Logical flag indicating whether Weakly Ordinal Alignment Condition is satisfied}
}
}
\description{
Performs biclustering, ranklustering, or their confirmatory variants on binary response data.
These methods simultaneously cluster both examinees and items into homogeneous groups
(or ordered ranks for ranklustering). The analysis reveals latent structures and patterns
in the data by creating a matrix with rows and columns arranged to highlight block structures.
}
\details{
Biclustering simultaneously clusters both rows (examinees) and columns (items) of a data matrix.
Unlike traditional clustering that groups either rows or columns, biclustering identifies
submatrices with similar patterns. Ranklustering is a variant that imposes an ordinal
structure on the classes, making it suitable for proficiency scaling.

The algorithm uses an Expectation-Maximization approach to iteratively estimate:
\enumerate{
\item Field membership of items (which items belong to which fields)
\item Class/rank membership of examinees (which examinees belong to which classes)
\item Field Reference Profiles (probability patterns for each field-class combination)
}

The confirmatory option allows for pre-specified field assignments, which is useful
when there is prior knowledge about item groupings or for testing hypothesized structures.
}
\examples{
\donttest{
# Perform Biclustering with Binary method (B)
# Analyze data with 5 fields and 6 classes
result.Bi <- Biclustering(J35S515, nfld = 5, ncls = 6, method = "B")

# Perform Biclustering with Rank method (R)
# Store results for further analysis and visualization
result.Rank <- Biclustering(J35S515, nfld = 5, ncls = 6, method = "R")

# Display the Bicluster Reference Matrix (BRM) as a heatmap
plot(result.Rank, type = "Array")

# Plot Field Reference Profiles (FRP) in a 2x3 grid
# Shows the probability patterns for each field
plot(result.Rank, type = "FRP", nc = 2, nr = 3)

# Plot Rank Membership Profiles (RMP) for students 1-9 in a 3x3 grid
# Shows posterior probability distribution of rank membership
plot(result.Rank, type = "RMP", students = 1:9, nc = 3, nr = 3)

# Example of confirmatory analysis with pre-specified fields
# Assign items 1-10 to field 1, 11-20 to field 2, etc.
field_assignments <- c(rep(1, 10), rep(2, 10), rep(3, 15))
result.Conf <- Biclustering(J35S515, nfld = 3, ncls = 5, conf = field_assignments)
}
\donttest{
# Perform Biclustering for nominal sample data()
# Analyze data with 5 fields and 6 classes
result.Bi <- Biclustering(J35S515, nfld = 5, ncls = 6, method = "B")
}
}
\references{
Shojima, K. (2012). Biclustering of binary data matrices using bilinear models.
Behaviormetrika, 39(2), 161-178.
}
