% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_TestItemFunctions.R
\name{passage}
\alias{passage}
\alias{passage.default}
\alias{passage.binary}
\title{Passage Rate of Student}
\usage{
passage(U, na = NULL, Z = NULL, w = NULL)

\method{passage}{default}(U, na = NULL, Z = NULL, w = NULL)

\method{passage}{binary}(U, na = NULL, Z = NULL, w = NULL)
}
\arguments{
\item{U}{Either an object of class "exametrika" or raw data. When raw data is given,
it is converted to the exametrika class with the \code{\link{dataFormat}} function.}

\item{na}{Values to be treated as missing values.}

\item{Z}{Missing indicator matrix of type matrix or data.frame. Values of 1 indicate
observed responses, while 0 indicates missing data.}

\item{w}{Item weight vector specifying the relative importance of each item.}
}
\value{
A numeric vector containing the passage rate for each student.
Values range from 0 to 1 (or maximum weight) where:
\itemize{
\item 1: Perfect score on all attempted items
\item 0: No correct answers
\item NA: No items attempted
}
}
\description{
The Passage Rate for each student is calculated as their Number-Right Score (NRS)
divided by the number of items presented to them. This function is applicable
only to binary response data.

The passage rate is calculated as:
\deqn{P_i = \frac{\sum_{j=1}^J z_{ij}u_{ij}w_j}{\sum_{j=1}^J z_{ij}}}
where:
\itemize{
\item \eqn{z_{ij}} is the missing response indicator (0/1)
\item \eqn{u_{ij}} is the response (0/1)
\item \eqn{w_j} is the item weight
}
}
\note{
This function is implemented using a binary data compatibility wrapper and
will raise an error if used with polytomous data.

The passage rate accounts for missing responses by only considering items that
were actually presented to each student. This provides a fair comparison
between students who attempted different numbers of items.
}
\examples{
# using sample dataset
passage(J15S500)

}
