% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline-loadasc.R
\name{load_asc}
\alias{load_asc}
\title{Load and parse SR Research EyeLink \code{.asc} files}
\usage{
load_asc(
  file,
  block = "auto",
  binocular_mode = c("average", "left", "right", "both"),
  verbose = TRUE
)
}
\arguments{
\item{file}{An SR Research EyeLink \code{.asc} file generated by the official
EyeLink \code{edf2asc} command}

\item{block}{Optional block number specification. The following are
valid options:
\itemize{
\item "auto" (default): Automatically handles multiple recording segments
embedded within the same \code{.asc} file. We recommend using this default
as this is likely the safer choice then assuming a single-block
recording (unless you know what you're doing).
\item \code{NULL}: Omits block column. Suitable for single-block recordings.
\item Numeric value: Manually sets block number based on the value
provided here.
}}

\item{binocular_mode}{Optional binocular mode specification. The
following are valid options:
\itemize{
\item "average" (default): Averages the left and right eye pupil sizes.
\item "left": Uses only the left eye pupil size.
\item "right": Uses only the right eye pupil size.
\item "both": Uses both the left and right eye pupil sizes independently.
}}

\item{verbose}{Logical. Whether to print verbose output (default TRUE).}
}
\value{
An object of S3 class \code{eyeris} with the following attributes:
\enumerate{
\item \code{file}: Path to the original \code{.asc} file.
\item \code{timeseries}: Data frame of all raw time series data from the
tracker.
\item \code{events}: Data frame of all event messages and their time
stamps.
\item \code{blinks}: Data frame of all blink events.
\item \code{info}: Data frame of various metadata parsed from the file
header.
\item \code{latest}: \code{eyeris} variable for tracking pipeline run history.
}

For binocular data with \code{binocular_mode = "both"}, returns a list
containing:
\enumerate{
\item \code{left}: An \code{eyeris} object for the left eye data.
\item \code{right}: An \code{eyeris} object for the right eye data.
\item \code{original_file}: Path to the original \code{.asc} file.
}
}
\description{
This function builds upon the \code{\link[eyelinker:read.asc]{eyelinker::read.asc()}} function to parse the
messages and metadata within the EyeLink \code{.asc} file. After loading and
additional processing, this function returns an S3 \code{eyeris} class for use in
all subsequent \code{eyeris} pipeline steps and functions.
}
\details{
This function is automatically called by \code{glassbox()} by default. If
needed, customize the parameters for \code{load_asc} by providing a parameter
list.

Users should prefer using \code{glassbox()} rather than invoking this
function directly unless they have a specific reason to customize the
pipeline manually.
}
\note{
This function is part of the \code{glassbox()} preprocessing pipeline and is not
intended for direct use in most cases. Provide parameters via
\code{load_asc = list(...)}.

Advanced users may call it directly if needed.
}
\examples{
demo_data <- eyelink_asc_demo_dataset()

demo_data |>
  eyeris::glassbox(load_asc = list(block = 1))

# Other useful parameter configurations
## (1) Basic usage (no block column specified)
demo_data |>
  eyeris::load_asc()

## (2) Manual specification of block number
demo_data |>
  eyeris::load_asc(block = 3)

## (3) Auto-detect multiple recording segments embedded within the same
##  file (i.e., the default behavior)
demo_data |>
  eyeris::load_asc(block = "auto")

## (4) Omit block column
demo_data |>
  eyeris::load_asc(block = NULL)

}
\seealso{
\code{\link[eyelinker:read.asc]{eyelinker::read.asc()}} which this function wraps.

\code{\link[=glassbox]{glassbox()}} for the recommended way to run this step
as part of the full \code{eyeris} glassbox preprocessing pipeline.
}
