% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_rowwise.R
\name{f_rowwise}
\alias{f_rowwise}
\title{A convenience function to group by every row}
\usage{
f_rowwise(data, ..., .ascending = TRUE, .cols = NULL, .name = ".row_id")
}
\arguments{
\item{data}{data frame.}

\item{...}{Variables to group by using \code{tidyselect}.}

\item{.ascending}{Should data be grouped in ascending row-wise order?
Default is \code{TRUE}.}

\item{.cols}{(Optional) alternative to \code{...} that accepts
a named character vector or numeric vector.
If speed is an expensive resource, it is recommended to use this.}

\item{.name}{Name of row-id column to be added.}
}
\value{
A row-wise \code{grouped_df}.
}
\description{
fastplyr currently cannot handle \code{rowwise_df} objects created through
\code{dplyr::rowwise()} and so this is a convenience function to allow you to
perform row-wise operations.
For common efficient row-wise functions,
see the 'kit' package.
}
