% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_metadata.R
\name{compare_metadata}
\alias{compare_metadata}
\title{Compare FCA Call Report metadata files between two folders}
\usage{
compare_metadata(dir1, dir2)
}
\arguments{
\item{dir1}{(String) The path to a folder containing FCA Call Report .TXT
files for a single quarter}

\item{dir2}{(String) The path to a folder containing FCA Call Report .TXT
files for a (different) single quarter}
}
\value{
A list containing information about differences in file names, file order,
and content differences between the metadata files in \code{dir1} and \code{dir2}
}
\description{
\code{compare_metadata()} compares the content of the metadata files (files that
start with "D_") between two specified folders containing FCA Call Report
data (from two different quarters).
}
\details{
\code{compare_metadata()} lists metadata files in each folder, identifies shared
metadata files, and then compares (a) the number of files, (b) file names,
(c) file order, and (d) file content (using the \code{waldo::compare()} function).
}
\examples{
\donttest{

  # Download data from September 2025
  path_1 <- tempfile("fcadata1")
  dir.create(path_1)

  download_data(
    year = 2025,
    month = 9,
    dest = path_1
  )

  # Download data from September 2011
  path_2 <- tempfile("fcadata2")
  dir.create(path_2)

  download_data(
    year = 2011,
    month = 9,
    dest = path_2
  )

  compare_metadata(path_1, path_2)

}
}
