% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reparam_image.R
\name{reparam_image}
\alias{reparam_image}
\title{Find optimum reparameterization between two images}
\usage{
reparam_image(It, Im, gam, b, stepsize = 1e-05, itermax = 1000, lmark = FALSE)
}
\arguments{
\item{It}{template image matrix}

\item{Im}{test image matrix}

\item{gam}{initial warping array}

\item{b}{basis matrix}

\item{stepsize}{gradient stepsize (default=1e-5)}

\item{itermax}{maximum number of iterations (default=1000)}

\item{lmark}{use landmarks (default=FALSE)}
}
\value{
Returns a list containing \item{gamnew}{final warping}
\item{Inew}{aligned image}
\item{H}{energy}
\item{stepsize}{final stepsize}
}
\description{
Finds the optimal warping function between two images using the elastic
framework
}
\references{
Q. Xie, S. Kurtek, E. Klassen, G. E. Christensen and A. Srivastava. Metric-based pairwise and multiple image registration. IEEE European Conference on Computer Vision (ECCV), September, 2014
}
\keyword{alignment}
\keyword{image}
