% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{individuals}
\alias{individuals}
\title{Individual Contributions Master metadata}
\format{
A data frame with 1000 rows and 16 columns providing information for each transaction:
\describe{
\item{cmte_id}{A 9-character alpha-numeric code assigned to a committee by the Federal Election Commission}
\item{amndt_ind}{Amendment indicator: Indicates if the report being filed is new (N), an amendment (A) to a previous
report or a termination (T) report}
\item{rpt_tp}{Indicates the type of report filed, listed here:
\url{https://www.fec.gov/campaign-finance-data/report-type-code-descriptions/}}
\item{transaction_pgi}{This code indicates the election for which the contribution was made.
EYYYY (election Primary, General, Other plus election year)}
\item{transaction_tp}{Transaction types, listed here:
\url{https://www.fec.gov/campaign-finance-data/transaction-type-code-descriptions/}}
\item{entity_tp}{Entity Type:

CAN = Candidate

CCM = Candidate Committee

COM = Committee

IND = Individual (a person)

ORG = Organization (not a committee and not a person)

PAC = Political Action Committee

PTY = Party Organization}
\item{name}{Contributor/lender/Transfer Name}
\item{city}{City}
\item{state}{State}
\item{zip_code}{ZIP Code}
\item{employer}{Employer}
\item{occupation}{Occupation}
\item{transaction_dt}{Transaction date (YYYY-MM-DD)}
\item{transaction_amt}{Transaction Amount}
\item{other_id}{For contributions from individuals this column is null.
For contributions from candidates or other committees this column will contain that contributor's FEC ID.}
\item{tran_id}{Only for Electronic Filings. A unique identifier associated with each itemization or transaction
appearing in an FEC electronic file. A transaction ID is unique for a specific committee for a specific report.}
}
}
\source{
\url{https://www.fec.gov/campaign-finance-data/contributions-individuals-file-description/}, updated 2020-03-02
}
\usage{
individuals
}
\description{
Information for a simple random sample of transactions from
individuals to candidates/committees.
}
\keyword{datasets}
