% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_modeler.R
\name{.fitter_curve}
\alias{.fitter_curve}
\title{General-purpose optimization}
\usage{
.fitter_curve(data, id, fn, method, lower, upper, control, metadata, trace)
}
\arguments{
\item{data}{A nested data.frame with columns <plot, genotype, row, range, data, initials, fx_params>.}

\item{id}{An optional vector of IDs to filter the data. Default is \code{NULL}, meaning all ids are used.}

\item{fn}{A string specifying the name of the function to be used for the curve fitting. Default is \code{"fn_lin_plat"}.}

\item{method}{A character vector specifying the optimization methods to be used. See \code{optimx} package for available methods. Default is \code{c("subplex", "pracmanm", "anms")}.}

\item{lower}{Numeric vector specifying the lower bounds for the parameters. Default is \code{-Inf} for all parameters.}

\item{upper}{Numeric vector specifying the upper bounds for the parameters. Default is \code{Inf} for all parameters.}

\item{control}{A list of control parameters to be passed to the optimization function. For example, \code{list(maxit = 500)}.}

\item{trace}{If \code{TRUE} , convergence monitoring of the current fit is reported in the console. \code{FALSE} by default.}
}
\value{
A list containing the following elements:
\describe{
  \item{\code{kkopt}}{opm object.}
  \item{\code{param}}{Data frame with best solution parameters.}
  \item{\code{rr}}{Data frame with all methods tested.}
  \item{\code{details}}{Additional details of the best solution.}
  \item{\code{hessian}}{Hessian matrix.}
  \item{\code{type}}{Data frame describing the type of coefficient (estimable of fixed)}
  \item{\code{conv}}{Convergency.}
  \item{\code{p}}{Number of parameters estimated.}
  \item{\code{n_obs}}{Number of observations.}
  \item{\code{uid}}{Unique identifier.}
  \item{\code{fn_name}}{Name of the curve-fitting function used.}
}
}
\description{
The function .fitter_curve is used internally to find the parameters requested.
}
\examples{
library(flexFitR)
data(dt_potato)
mod_1 <- dt_potato |>
  modeler(
    x = DAP,
    y = GLI,
    grp = Plot,
    fn = "fn_lin_pl_lin",
    parameters = c(t1 = 38.7, t2 = 62, t3 = 90, k = 0.32, beta = -0.01),
    subset = 195,
    options = list(add_zero = TRUE)
  )
}
\keyword{internal}
