% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpf_exporters.R
\name{export_as_rtf}
\alias{export_as_rtf}
\title{Export as RTF}
\usage{
export_as_rtf(
  x,
  file = NULL,
  colwidths = NULL,
  page_type = "letter",
  pg_width = page_dim(page_type)[if (landscape) 2 else 1],
  pg_height = page_dim(page_type)[if (landscape) 1 else 2],
  landscape = FALSE,
  margins = c(bottom = 0.5, left = 0.75, top = 0.5, right = 0.75),
  font_family = "Courier",
  font_size = 8,
  lineheight = 1,
  fontspec = font_spec(font_family, font_size, lineheight),
  paginate = TRUE,
  ...
)
}
\arguments{
\item{x}{(\code{ANY})\cr a table-like object to export. Must have an applicable \code{matrix_form} method.}

\item{file}{(\code{string} or \code{NULL})\cr if non-\code{NULL}, the path to write a text file to
containing \code{x} rendered as ASCII text.}

\item{colwidths}{(\code{numeric})\cr vector of column widths (in characters) for use in vertical pagination.}

\item{page_type}{(\code{string})\cr name of a page type. See \code{\link{page_types}}. Ignored
when \code{pg_width} and \code{pg_height} are set directly.}

\item{pg_width}{(\code{numeric(1)})\cr page width in inches.}

\item{pg_height}{(\code{numeric(1)})\cr page height in inches.}

\item{landscape}{(\code{flag})\cr whether the dimensions of \code{page_type} should be
inverted for landscape orientation. Defaults to \code{FALSE}, ignored when \code{pg_width} and
\code{pg_height} are set directly.}

\item{margins}{(\code{numeric(4)})\cr named numeric vector containing \code{"bottom"}, \code{"left"},
\code{"top"}, and \code{"right"} margins in inches. Defaults to \code{.5} inches for both vertical
margins and \code{.75} for both horizontal margins.}

\item{font_family}{(\code{string})\cr name of a font family. An error will be thrown
if the family named is not monospaced. Defaults to \code{"Courier"}.}

\item{font_size}{(\code{numeric(1)})\cr font size. Defaults to \code{12}.}

\item{lineheight}{(\code{numeric(1)})\cr line height. Defaults to \code{1}.}

\item{fontspec}{(\code{font_spec})\cr a font_spec object specifying the font information to use for
calculating string widths and heights, as returned by \code{\link[=font_spec]{font_spec()}}.}

\item{paginate}{(\code{flag})\cr whether pagination should be performed. Defaults to \code{TRUE}
if page size is specified (including the default).}

\item{...}{additional parameters passed to \code{\link[=paginate_to_mpfs]{paginate_to_mpfs()}}.}
}
\description{
Experimental export to the rich text format (RTF) format.
}
\details{
RTF export occurs via the following steps:
\itemize{
\item The table is paginated to the specified page size (vertically and horizontally).
\item Each separate page is converted to a \code{MatrixPrintForm} object and then to
RTF-encoded text.
\item Separate RTF text chunks are combined and written to a single RTF file.
}

Conversion of \code{MatrixPrintForm} objects to RTF is done via \code{\link[=mpf_to_rtf]{mpf_to_rtf()}}.
}
