% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transect_phys.R
\name{transect_phys}
\alias{transect_phys}
\title{Obtain physiognometric information for a floristic quality transect assessment}
\usage{
transect_phys(data_set)
}
\arguments{
\item{data_set}{A data set downloaded from
\href{https://universalfqa.org/}{universalfqa.org} either manually or using
\code{\link[=download_transect]{download_transect()}}.}
}
\value{
A data frame with 6 columns:
\itemize{
   \item Physiognomy (character)
   \item Frequency (numeric)
   \item Coverage (numeric)
   \item Relative Frequency (\%) (numeric)
   \item Relative Coverage (\%) (numeric)
   \item Relative Importance Value (numeric)
}
}
\description{
\code{transect_phys()} returns a data frame with physiognometric information
for a floristic quality transect assessment obtained from
\href{https://universalfqa.org/}{universalfqa.org}.
}
\examples{
\donttest{
# While transect_phys can be used with a .csv file downloaded
# manually from the universal FQA website, it is most typically used
# in combination with download_transect().

tyler <- download_transect(6352)
transect_phys(tyler)
}

}
