% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_phaseI_training.R
\name{get_outliers_mfd}
\alias{get_outliers_mfd}
\title{Get outliers from multivariate functional data}
\usage{
get_outliers_mfd(mfdobj)
}
\arguments{
\item{mfdobj}{A multivariate functional data object of class mfd}
}
\value{
A numeric vector with the indexes of the functional observations
signaled as outliers.
}
\description{
Get outliers from multivariate functional data
using the functional boxplot with the
modified band depth of Sun et al. (2011, 2012).
This function relies on the \code{fbplot} function
of the \code{roahd} package.
}
\examples{
library(funcharts)
data("air")
air <- lapply(air, function(x) x[1:20, , drop = FALSE])
fun_covariates <- c("CO", "temperature")
mfdobj_x <- get_mfd_list(air[fun_covariates], lambda = 1e-2)
get_outliers_mfd(mfdobj_x)

}
\references{
\itemize{
\item Sun, Y., & Genton, M. G. (2011). Functional boxplots.
\emph{Journal of Computational and Graphical Statistics}, 20(2), 316-334.
\item Sun, Y., & Genton, M. G. (2012).
Adjusted functional boxplots for spatio-temporal data visualization
and outlier detection. \emph{Environmetrics}, 23(1), 54-64.
}
}
