% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_mfd.R
\name{minus_mfd}
\alias{minus_mfd}
\alias{-.mfd}
\title{Subtract multivariate functional data (and unary negation)}
\usage{
minus_mfd(mfdobj1, mfdobj2)

\method{-}{mfd}(mfdobj1, mfdobj2)
}
\arguments{
\item{mfdobj1, mfdobj2}{Objects of class \code{mfd}. If \code{mfdobj2} is missing,
unary minus is applied to \code{mfdobj1}.}
}
\value{
An object of class \code{mfd} with coefficients equal to the (possibly
replicated) difference \code{mfdobj1 - mfdobj2}, or the negation of
\code{mfdobj1} for unary minus.
}
\description{
Subtracts two objects of class \code{mfd} (elementwise on their coefficient arrays).
The same basis, variable-count, and observation-replication rules as in
\code{\link{plus_mfd}} apply. If \code{mfdobj2} is missing, returns the
unary negation of \code{mfdobj1}.
}
\examples{
# mfdobj_a - mfdobj_b
# minus_mfd(mfdobj_a, mfdobj_b)
# Unary minus:
# -mfdobj_a

}
\seealso{
\code{\link{plus_mfd}}, \code{\link{nobs}}, \code{\link{nbasis}}, \code{\link{nvar}}, \code{\link{mfd}}
}
