% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cobra.R
\name{cobra}
\alias{cobra}
\title{Cobra Meta Learner}
\usage{
cobra(x, y, tune = "epsilon", k_folds = NULL, eps = NULL)
}
\arguments{
\item{x}{\code{data.frame} \cr
A training data, where rows are observations and
columns are predictions from individual learners. Use \code{NA} for missing predictions.}

\item{y}{\code{vector} \cr
A vector containing the training targets. This can be a binary or two-level factor variable.}

\item{tune}{\code{character} \cr
A character value specifying the tuning mode:
\itemize{
\item \code{"alpha_epsilon"}: Tunes both \code{alpha} (number of learners) and \code{epsilon} (proximity threshold) via cross-validation.
\item \code{"epsilon"}: Tunes \code{epsilon} only via cross-validation.
\item \code{"user"}: No tuning; the user provides an optimal \code{epsilon}.
#' The default value is \code{epsilon}.
}}

\item{k_folds}{\code{integer} \cr
Number of folds for cross-validation when \code{tune = "alpha_epsilon"} or \code{"epsilon"}.
Default is \code{10}.}

\item{eps}{\code{numeric} \cr
A numeric value for the proximity threshold, used only when \code{tune = "user"}.
Defaults to \code{0.1}.}
}
\value{
An object of class \code{cobra} containing the training data, target values, and chosen parameters.
}
\description{
The function \code{cobra} implements the COBRA (COmBined Regression Alternative),
an aggregation method for combining predictions from multiple individual learners.
This method aims to tune key parameters for achieving optimal predictions
by averaging the target values of similar candidates in the training dataset's predictions.
Only the training points that are sufficiently similar to the test point
(based on the proximity threshold \code{epsilon}) are used for prediction.
If no suitable training points are found, the function returns \code{NA}.
}
\examples{
# Example usage
set.seed(123)
x_train <- data.frame(a = runif(10L), b = runif(10L))
y_train <- sample(0L:1L, size = 10L, replace = TRUE)

# Train the model with epsilon optimization
cobra_model <- cobra(x = x_train, y = y_train, tune = "epsilon", k_folds = 2)

# Make predictions on new data
set.seed(156)
x_new <- data.frame(a = runif(5L), b = runif(5L))
prediction <- predict(object = cobra_model, data = x_new)

}
\references{
Biau, G., Fischer, A., Guedj, B., & Malley, J. D. (2014). COBRA: A combined regression strategy. The Journal of Multivariate Analysis 46:18-28
}
