% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Training.R
\name{Training}
\alias{Training}
\title{Training Class}
\description{
This is a primary classes of fuseMLR. An object from this class
is designed to contain multiple training layers, but only one meta training layer.

The Training class is structured as followed:
\itemize{
\item \link{TrainLayer}: Specific layer containing:
\itemize{
\item \link{Lrner}: Specific learner. This must be set by the user.
\item \link{TrainData}: Specific training dataset. This must be set up by the user.
\item \link{Model}: Specific model. This is set up by training the learner on the training data.
}
\item \link{TrainMetaLayer}: Basically a \link{TrainLayer}, but with some specific properties.
\itemize{
\item \link{Lrner}: This is the meta learner, it must be set up by the user.
\item \link{TrainData}: Specific modality-specific prediction data. This is set up internally after cross-validation.
\item \link{Model}: Specific meta model. This is set up by training the learner on the training data.
}
}

Use the function \code{train} for training and \code{predict} for predicting.
}
\seealso{
\link{TrainLayer}

\link{Testing} and \link{Predicting}
}
\section{Super class}{
\code{\link[fuseMLR:HashTable]{fuseMLR::HashTable}} -> \code{Training}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Training-new}{\code{Training$new()}}
\item \href{#method-Training-print}{\code{Training$print()}}
\item \href{#method-Training-trainLayer}{\code{Training$trainLayer()}}
\item \href{#method-Training-predictLayer}{\code{Training$predictLayer()}}
\item \href{#method-Training-createMetaTrainData}{\code{Training$createMetaTrainData()}}
\item \href{#method-Training-train}{\code{Training$train()}}
\item \href{#method-Training-predict}{\code{Training$predict()}}
\item \href{#method-Training-varSelection}{\code{Training$varSelection()}}
\item \href{#method-Training-getTargetValues}{\code{Training$getTargetValues()}}
\item \href{#method-Training-getIndIDs}{\code{Training$getIndIDs()}}
\item \href{#method-Training-getLayer}{\code{Training$getLayer()}}
\item \href{#method-Training-getTrainMetaLayer}{\code{Training$getTrainMetaLayer()}}
\item \href{#method-Training-getModel}{\code{Training$getModel()}}
\item \href{#method-Training-getData}{\code{Training$getData()}}
\item \href{#method-Training-removeLayer}{\code{Training$removeLayer()}}
\item \href{#method-Training-removeTrainMetaLayer}{\code{Training$removeTrainMetaLayer()}}
\item \href{#method-Training-getIndCol}{\code{Training$getIndCol()}}
\item \href{#method-Training-getTarget}{\code{Training$getTarget()}}
\item \href{#method-Training-getVerbose}{\code{Training$getVerbose()}}
\item \href{#method-Training-getUseVarSel}{\code{Training$getUseVarSel()}}
\item \href{#method-Training-getVarSelDone}{\code{Training$getVarSelDone()}}
\item \href{#method-Training-increaseNbTrainedLayer}{\code{Training$increaseNbTrainedLayer()}}
\item \href{#method-Training-checkTargetExist}{\code{Training$checkTargetExist()}}
\item \href{#method-Training-getTargetObj}{\code{Training$getTargetObj()}}
\item \href{#method-Training-getProblemTyp}{\code{Training$getProblemTyp()}}
\item \href{#method-Training-setImpute}{\code{Training$setImpute()}}
\item \href{#method-Training-testOverlap}{\code{Training$testOverlap()}}
\item \href{#method-Training-upset}{\code{Training$upset()}}
\item \href{#method-Training-summary}{\code{Training$summary()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="add2HashTable"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-add2HashTable'><code>fuseMLR::HashTable$add2HashTable()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="checkClassExist"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-checkClassExist'><code>fuseMLR::HashTable$checkClassExist()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="getFromHashTable"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-getFromHashTable'><code>fuseMLR::HashTable$getFromHashTable()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="getHashTable"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-getHashTable'><code>fuseMLR::HashTable$getHashTable()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="getId"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-getId'><code>fuseMLR::HashTable$getId()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="getKeyClass"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-getKeyClass'><code>fuseMLR::HashTable$getKeyClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="removeFromHashTable"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-removeFromHashTable'><code>fuseMLR::HashTable$removeFromHashTable()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Training-new"></a>}}
\if{latex}{\out{\hypertarget{method-Training-new}{}}}
\subsection{Method \code{new()}}{
constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Training$new(
  id,
  ind_col,
  target,
  target_df,
  problem_type = "classification",
  verbose = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{character} \cr}

\item{\code{ind_col}}{\code{character} \cr
Name of column of individuals IDS.}

\item{\code{target}}{\code{character} \cr
Name of the target variable.}

\item{\code{target_df}}{\code{data.frame} \cr
Data frame with two columns: individual IDs and response variable values.}

\item{\code{problem_type}}{\code{character} \cr
Either "classification" or "regression".}

\item{\code{verbose}}{\code{boolean} \cr
Warning messages will be displayed if set to TRUE.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Training-print"></a>}}
\if{latex}{\out{\hypertarget{method-Training-print}{}}}
\subsection{Method \code{print()}}{
Printer
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Training$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{\code{any}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Training-trainLayer"></a>}}
\if{latex}{\out{\hypertarget{method-Training-trainLayer}{}}}
\subsection{Method \code{trainLayer()}}{
Train each layer of the current Training.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Training$trainLayer(ind_subset = NULL, use_var_sel = FALSE, verbose = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ind_subset}}{\code{character}\cr
Subset of individuals IDs to be used for training.}

\item{\code{use_var_sel}}{\code{boolean} \cr
If TRUE, selected variables available at each layer are used.}

\item{\code{verbose}}{\code{boolean} \cr
Warning messages will be displayed if set to TRUE.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns the object itself, with a model for each layer.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Training-predictLayer"></a>}}
\if{latex}{\out{\hypertarget{method-Training-predictLayer}{}}}
\subsection{Method \code{predictLayer()}}{
Predicts values given new data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Training$predictLayer(testing, ind_subset = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{testing}}{\code{TestData} \cr
Object of class \link{TestData}.}

\item{\code{ind_subset}}{\code{vector} \cr
Subset of individuals IDs to be used for training.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \link{Training} with predicted values for each layer.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Training-createMetaTrainData"></a>}}
\if{latex}{\out{\hypertarget{method-Training-createMetaTrainData}{}}}
\subsection{Method \code{createMetaTrainData()}}{
Creates a meta training dataset and assigns it to the meta layer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Training$createMetaTrainData(
  resampling_method,
  resampling_arg,
  use_var_sel,
  impute = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resampling_method}}{\code{function} \cr
Function for internal validation.}

\item{\code{resampling_arg}}{\code{list} \cr
List of arguments to be passed to the function.}

\item{\code{use_var_sel}}{\code{boolean} \cr
If TRUE, selected variables available at each layer are used.}

\item{\code{impute}}{\code{boolean} \cr
If TRUE, mode or median based imputation is performed on the modality-specific predictions.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The current object is returned, with a meta training dataset assigned to the meta layer.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Training-train"></a>}}
\if{latex}{\out{\hypertarget{method-Training-train}{}}}
\subsection{Method \code{train()}}{
Trains the current object. All leaners and the meta learner are trained.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Training$train(
  ind_subset = NULL,
  use_var_sel = FALSE,
  resampling_method = NULL,
  resampling_arg = list(),
  seed = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ind_subset}}{\code{vector} \cr
ID subset to be used for training.}

\item{\code{use_var_sel}}{\code{boolean} \cr
If TRUE, variable selection is performed before training.}

\item{\code{resampling_method}}{\code{function} \cr
Function for internal validation. If not specify, the \code{resampling} function from the package \code{caret} is used for a 10-folds cross-validation.}

\item{\code{resampling_arg}}{\code{list} \cr
List of arguments to be passed to the function.}

\item{\code{seed}}{\code{integer} \cr
Random seed. Default is NULL, which generates the seed from \code{R}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The current object is returned, with each learner trained on each layer.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Training-predict"></a>}}
\if{latex}{\out{\hypertarget{method-Training-predict}{}}}
\subsection{Method \code{predict()}}{
Compute predictions for a testing object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Training$predict(testing, ind_subset = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{testing}}{\code{Testing} \cr
A new testing object to be predicted.}

\item{\code{ind_subset}}{\code{vector} \cr
Vector of IDs to be predicted.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The predicted object. All layers and the meta layer are predicted. This is the final predicted object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Training-varSelection"></a>}}
\if{latex}{\out{\hypertarget{method-Training-varSelection}{}}}
\subsection{Method \code{varSelection()}}{
Variable selection on the current training object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Training$varSelection(ind_subset = NULL, verbose = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ind_subset}}{\code{vector} \cr
ID subset of individuals to be used for variable selection.}

\item{\code{verbose}}{\code{boolean} \cr
Warning messages will be displayed if set to TRUE.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The current layer is returned with the resulting model.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Training-getTargetValues"></a>}}
\if{latex}{\out{\hypertarget{method-Training-getTargetValues}{}}}
\subsection{Method \code{getTargetValues()}}{
Gather target values from all layer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Training$getTargetValues()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{data.frame} containing individuals IDs and corresponding target values.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Training-getIndIDs"></a>}}
\if{latex}{\out{\hypertarget{method-Training-getIndIDs}{}}}
\subsection{Method \code{getIndIDs()}}{
Gather individual IDs from all layer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Training$getIndIDs()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{data.frame} containing individuals IDs.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Training-getLayer"></a>}}
\if{latex}{\out{\hypertarget{method-Training-getLayer}{}}}
\subsection{Method \code{getLayer()}}{
Get a layer of a given ID.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Training$getLayer(id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{character} \cr
The ID of the layer to be returned.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \link{TrainLayer} object is returned for the given ID.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Training-getTrainMetaLayer"></a>}}
\if{latex}{\out{\hypertarget{method-Training-getTrainMetaLayer}{}}}
\subsection{Method \code{getTrainMetaLayer()}}{
Getter of the meta layer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Training$getTrainMetaLayer()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Object from class \link{TrainMetaLayer}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Training-getModel"></a>}}
\if{latex}{\out{\hypertarget{method-Training-getModel}{}}}
\subsection{Method \code{getModel()}}{
Retrieve models from all layer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Training$getModel()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{list} containing all (base and meta) models.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Training-getData"></a>}}
\if{latex}{\out{\hypertarget{method-Training-getData}{}}}
\subsection{Method \code{getData()}}{
Retrieve modality-specific predictions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Training$getData()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{list} containing all (base and meta) models.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Training-removeLayer"></a>}}
\if{latex}{\out{\hypertarget{method-Training-removeLayer}{}}}
\subsection{Method \code{removeLayer()}}{
Remove a layer of a given ID.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Training$removeLayer(id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{character} \cr
The ID of the layer to be removed.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \link{TrainLayer} object is returned for the given ID.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Training-removeTrainMetaLayer"></a>}}
\if{latex}{\out{\hypertarget{method-Training-removeTrainMetaLayer}{}}}
\subsection{Method \code{removeTrainMetaLayer()}}{
Remove the meta layer from the current \link{Training} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Training$removeTrainMetaLayer()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Training-getIndCol"></a>}}
\if{latex}{\out{\hypertarget{method-Training-getIndCol}{}}}
\subsection{Method \code{getIndCol()}}{
Getter of the individual column name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Training$getIndCol()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Training-getTarget"></a>}}
\if{latex}{\out{\hypertarget{method-Training-getTarget}{}}}
\subsection{Method \code{getTarget()}}{
Getter of the target variable name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Training$getTarget()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Training-getVerbose"></a>}}
\if{latex}{\out{\hypertarget{method-Training-getVerbose}{}}}
\subsection{Method \code{getVerbose()}}{
Getter of the verbose setting.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Training$getVerbose()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Training-getUseVarSel"></a>}}
\if{latex}{\out{\hypertarget{method-Training-getUseVarSel}{}}}
\subsection{Method \code{getUseVarSel()}}{
Getter of the use_var_sel field.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Training$getUseVarSel()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Training-getVarSelDone"></a>}}
\if{latex}{\out{\hypertarget{method-Training-getVarSelDone}{}}}
\subsection{Method \code{getVarSelDone()}}{
Getter of the use_var_sel field.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Training$getVarSelDone()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Training-increaseNbTrainedLayer"></a>}}
\if{latex}{\out{\hypertarget{method-Training-increaseNbTrainedLayer}{}}}
\subsection{Method \code{increaseNbTrainedLayer()}}{
Increase the number of trained layer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Training$increaseNbTrainedLayer()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Training-checkTargetExist"></a>}}
\if{latex}{\out{\hypertarget{method-Training-checkTargetExist}{}}}
\subsection{Method \code{checkTargetExist()}}{
Check whether a target object has already been stored.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Training$checkTargetExist()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Boolean value
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Training-getTargetObj"></a>}}
\if{latex}{\out{\hypertarget{method-Training-getTargetObj}{}}}
\subsection{Method \code{getTargetObj()}}{
Getter of the target object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Training$getTargetObj()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Training-getProblemTyp"></a>}}
\if{latex}{\out{\hypertarget{method-Training-getProblemTyp}{}}}
\subsection{Method \code{getProblemTyp()}}{
Getter of the problem type.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Training$getProblemTyp()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Training-setImpute"></a>}}
\if{latex}{\out{\hypertarget{method-Training-setImpute}{}}}
\subsection{Method \code{setImpute()}}{
Set imputation action na.action.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Training$setImpute(impute)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{impute}}{\code{character} \cr
How to handle missing values.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Training-testOverlap"></a>}}
\if{latex}{\out{\hypertarget{method-Training-testOverlap}{}}}
\subsection{Method \code{testOverlap()}}{
Test that individuals overlap over layers.
At least five individuals must overlapped.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Training$testOverlap()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Training-upset"></a>}}
\if{latex}{\out{\hypertarget{method-Training-upset}{}}}
\subsection{Method \code{upset()}}{
UpSet plot to show an overview of the overlap of individuals across various layers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Training$upset(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{\code{any} \cr
Further parameters to be passed to the \code{upset} function from package \code{UpSetR}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Training-summary"></a>}}
\if{latex}{\out{\hypertarget{method-Training-summary}{}}}
\subsection{Method \code{summary()}}{
Generate training summary
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Training$summary()}\if{html}{\out{</div>}}
}

}
}
