% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.galamm.R
\name{print.galamm}
\alias{print.galamm}
\title{Print method for GALAMM fits}
\usage{
\method{print}{galamm}(x, ...)
}
\arguments{
\item{x}{An object of class \code{galamm} returned from \code{\link{galamm}}.}

\item{...}{Further arguments passed on to other methods. Currently not used.}
}
\value{
Summary printed to screen. Invisibly returns the argument \code{x}.
}
\description{
Print method for GALAMM fits
}
\examples{
# Linear mixed model with heteroscedastic residuals
mod <- galamm(
  formula = y ~ x + (1 | id),
  weights = ~ (1 | item),
  data = hsced
)

print(mod)

}
\seealso{
\code{\link[=summary.galamm]{summary.galamm()}} for the summary function and \code{\link[=print]{print()}} for the
generic.

Other summary functions: 
\code{\link{anova.galamm}()},
\code{\link{plot.galamm}()},
\code{\link{plot_smooth.galamm}()},
\code{\link{print.summary.galamm}()},
\code{\link{summary.galamm}()}
}
\concept{summary functions}
