      SUBROUTINE HEADER(MSG,VER)
C
C ASSEMBLE STANDARD OUTPUT HEADING FOR USE WITH SUBR. "EJECT" BELOW
C
      CHARACTER   MSG*(*), VER*(*)
      PARAMETER (MAXCOL=132-18)
      CHARACTER   HDR*(MAXCOL), DTSTR*18
      LOGICAL     FIRST
C
      DATA HDR /' '/
      DATA FIRST /.TRUE./
C
      NMSG = LENSTR(MSG)
      IF (NMSG*2-1 .GT. MAXCOL-18) THEN
         call intpr('HEADER: MESSAGE TOO LONG',-1,0,0)
         STOP
      END IF
C
      NVER = LENSTR(VER)
      IF (NVER .GT. 18) THEN
         call intpr('HEADER: VERSION TOO LONG',-1,0,0)
         STOP
      END IF
C
C PUT MESSAGE IN TOP LINE, CENTERED AND DOUBLE SPACED
C
      HDR = ' '
      I1 = (MAXCOL-18)/2 - NMSG + 2
      DO 100 I=1,NMSG
         HDR(I1:I1) = MSG(I:I)
         I1 = I1 + 2
100   CONTINUE
C
C RIGHT ALIGN VERSION DATE IN TOP LINE
C
      IF (NVER .GT. 0) HDR(MAXCOL-NVER+1:) = VER
      RETURN

C --------------------------------------------------------------------
C
C SUBROUTINE TO ADVANCE SPECIFIED UNIT TO TOP-OF-FORM AND PRINT HEADER
C
      ENTRY EJECT(LFN)
C
      CALL GETDT(DTSTR)
C
      IF (FIRST) THEN
C        BYPASS PAGE EJECT ON FIRST ENTRY
         WRITE (LFN,1100) DTSTR, HDR
CHAR     WRITE (LFN,1100) ' ' // DTSTR, HDR
         FIRST = .FALSE.
      ELSE
C        PAGE EJECT THEN WRITE THREE LINE HEADER
         WRITE (LFN,1100) CHAR(12) // DTSTR, HDR
CHAR     WRITE (LFN,1100) '1' // DTSTR, HDR
      END IF
C
 1100 FORMAT(A,A,
     +      /33X,'DIVISION OF BIOSTATISTICS, WASHINGTON UNIVERSITY,',
     +          ' ST. LOUIS, MISSOURI',/)
      END
