      SUBROUTINE ERRLOC(LFN,STRING,ICOL)
C
C WRITES A CHARACTER STRING TO UNIT 'LFN', FOLLOWED BY A LINE
C CONTAINING A '^' POINTING TO COLUMN 'ICOL'
C
      CHARACTER   STRING*(*)
      PARAMETER (MAXOUT=80)
C
      NCHARS = LEN(STRING)
      IF (ICOL.LT.1 .OR. ICOL.GT.NCHARS) RETURN
C
      IF (ICOL .LE. MAXOUT) THEN
         I2 = MIN(MAXOUT,NCHARS)
         WRITE (LFN,'(1X,A)') STRING(1:I2)
         WRITE (LFN,'(133A)') (' ',I=1,ICOL),'^'
C
      ELSE
         I1 = ICOL - 50
         I2 = MIN( I1+MAXOUT-1, NCHARS)
         WRITE (LFN,'(1X,A)') STRING(I1:I2)
         WRITE (LFN,'(1X,50X,A)') '^'
      END IF
C
      RETURN
      END
C     +---------------------------------------------------------------+
C     !              SEVERAL STRING PROCESSING UTILITIES              !
C     +---------------------------------------------------------------+
C
      FUNCTION ISTRC(STR1,STR2)
C
C COMPARES TWO STRINGS, RETURNS LEXICAL ORDERING AS FOLLOWS
C
C ISTRC = 0    TWO STRINGS ARE EQUAL
C ISTRC =-1    STR1 IS LEXICALLY LESS THAN STR2
C ISTRC =+1    STR1 IS LEXICALLY GREATER THAN STR2
C
      CHARACTER STR1*(*), STR2*(*)
C
C FIND LENGTH OF STR1 WITHOUT TRAILING BLANKS
      N1 = 1
      DO 100 I=LEN(STR1),2,-1
         IF (STR1(I:I) .NE. ' ') THEN
            N1 = I
            GO TO 110
         END IF
100   CONTINUE
110   CONTINUE
C
C FIND LENGTH OF STR2 WITHOUT TRAILING BLANKS
      N2 = 1
      DO 200 I=LEN(STR2),2,-1
         IF (STR2(I:I) .NE. ' ') THEN
            N2 = I
            GO TO 210
         END IF
200   CONTINUE
210   CONTINUE
C
      istrc = 0
      IF      ( STR1(:N1) .EQ. STR2(:N2) ) THEN
         ISTRC = 0
      ELSE IF ( STR1(:N1) .LT. STR2(:N2) ) THEN
         ISTRC = -1
      ELSE IF ( STR1(:N1) .GT. STR2(:N2) ) THEN
         ISTRC =  1
      END IF
      END

      SUBROUTINE PAR(A,ICOL,ILEFT,IRIGHT,ISTAT)
C
C RETURNS POSITION OF MATCHING RIGHT PARENTHESIS IN A STRING
C
C THE STRING SHOULD BEGIN WITH A "(", PRECEEDED BY BLANKS ONLY, AND
C MAY CONTAIN NESTED PARENTHESES.
C
C INPUT ARGUMENT:
C     A      -- INPUT STRING
C     ICOL   -- COLUMN IN 'A' TO BEGIN PROCESSING (UNCHANGED)
C
C OUTPUT ARGUMENTS:
C     ILEFT  -- COLUMN # OF FIRST "(" IN STRING
C     IRIGHT -- COLUMN # OF MATCHING ")"
C     ISTAT  -- 0=OK ; -1=ERROR
C
      CHARACTER   A*(*)
C
      NCHARS = LEN(A)
      IF (ICOL.LE.0 .OR. ICOL.GT.NCHARS) GO TO 800
C
      ILEFT  = 0
      IRIGHT = 0
C
C    SKIP LEADING BLANKS:
      JCOL = NSPACE(A,ICOL,ISTAT)
      IF (ISTAT .NE. 0) GO TO 800
C
C    FIND LEFT PAREN:
      IF (A(JCOL:JCOL) .NE. '(') GO TO 800
      ILEFT = JCOL
C
C    AND FIND MATCHING RIGHT PAREN:
      NEST = 1
100   CONTINUE
         JCOL = JCOL + 1
         IF (JCOL.GT.NCHARS) GO TO 800
         IF (A(JCOL:JCOL) .EQ. '(')  NEST = NEST + 1
         IF (A(JCOL:JCOL) .EQ. ')')  NEST = NEST - 1
         IF (NEST .EQ. 0) GO TO 199
      GO TO 100
C
199   IRIGHT = JCOL
      GO TO 900
C
C UNSUCCESSFUL RETURN
C
800   ISTAT = -1
      GO TO 999
C
C SUCCESSFUL RETURN
C
900   ISTAT = 0
999   RETURN
      END

      DOUBLE PRECISION FUNCTION XNO(STRING,ICOL,ISTAT)
C
C CONVERTS A NUMBER IN CHARACTER-STRING FORM TO FLOATING POINT
C
C (ALLOWS FOR NUMBERS IN FLOATING-POINT OR INTEGER FORM, BUT NOT
C SCIENTIFIC NOTATION.  THE STRING IS TERMINATED BY THE FIRST
C BLANK OR INVALID CHARACTER ENCOUNTERED.)
C
C INPUT ARGUMENTS:
C     STRING -- INPUT STRING
C     ICOL   -- COLUMN IN 'STRING' TO BEGIN PROCESSING
C
C OUTPUT ARGUMENTS:
C     ICOL   -- PUSHED TO NEXT COLUMN FOLLOWING NUMBER
C     ISTAT  -- 0=OK ; -1=ERROR ; -2=BLANK
C
C FUNCTION VALUE -- FLOATING POINT FORM OF INPUT STRING
C
      CHARACTER STRING*(*)
      CHARACTER C*1, FMT*7
C
C    INITIALIZE FORMAT STATEMENT:
      DATA FMT / '(F00.0)' /
C
C    CHECK ICOL:
      NCHARS = LEN(STRING)
      IF (ICOL.LE.0 .OR. ICOL.GT.NCHARS) GO TO 800
C
C    INITIALIZE COLUMN POINTERS, AND CHECK FOR BLANK STRING:
      IFIRST = NSPACE(STRING,ICOL,ISTAT)
      IF (ISTAT .NE. 0) GO TO 810
C
      ILAST  = 0
      I = IFIRST
C
C    HANDLE MINUS SIGN:
      IF (STRING(I:I) .EQ. '-') I = I + 1
C
C    FIND FIRST NON-DIGIT:
100   IF (I .GT. NCHARS) GO TO 199
         C = STRING(I:I)
         IF ( (C.LT.'0' .OR. C.GT.'9') .AND. C.NE.'.') GO TO 199
         ILAST = I
         I = I + 1
      GO TO 100
C
199   CONTINUE
C
C    CHECK FOR ZERO LENGTH STRING:
      N = ILAST - IFIRST + 1
      IF (N .LE. 0) GO TO 800
C
C    ASSEMBLE THE FORMAT STATEMENT:
      WRITE (FMT(3:4),'(I2)') N
C
C    READ THE NUMBER INTO XNO:
      READ (STRING(IFIRST:ILAST),FMT,ERR=800) XNO
C
C    FINALLY, PUSH ICOL PAST THE NUMBER:
      ICOL = ILAST + 1
      GO TO 900
C
C INVALID NUMBER
C
800   ISTAT = -1
      XNO = 0.0
      GO TO 999
C
C BLANK STRING
C
810   ISTAT = -2
      XNO = 0.0
      GO TO 999
C
C SUCCESSFUL RETURN
C
900   ISTAT = 0
999   RETURN
      END

      INTEGER FUNCTION NSPACE(A,ICOL,ISTAT)
C
C  RETURNS POSITION OF THE NEXT NON-BLANK CHARACTER IN A STRING OF TEXT
C
C     INPUT:
C              'A()'   -- INPUT STRING (CHARACTER FORMAT)
C              'ICOL'  -- STARTING COLUMN
C
C     RETURNED:
C              'ISTAT' -- -1 = ERROR, 0 = OK
C
C     FUNCTION VALUE:
C               NEXT NON-BLANK COLUMN AT OR PAST 'ICOL' (ICOL IF ERROR)
C
      CHARACTER  A*(*)
C
      NCHAR = LEN(A)
      IF (ICOL.LE.0 .OR. ICOL.GT.NCHAR) GO TO 800
C
      NEWCOL = ICOL
100   IF (A(NEWCOL:NEWCOL) .NE. ' ') GO TO 900
         NEWCOL = NEWCOL + 1
         IF (NEWCOL.GT.NCHAR) GO TO 800
      GO TO 100
C
C UNSUCCESSFUL RETURN
C
800   ISTAT = -1
      NSPACE = ICOL
      GO TO 999
C
C SUCCESSFUL RETURN
C
900   ISTAT = 0
      NSPACE = NEWCOL
999   RETURN
      END

      INTEGER FUNCTION LENSTR (STRING)
C
C  RETURNS THE LENGTH OF A STRING TO THE LAST NON-BLANK CHARACTER
C
      CHARACTER STRING*(*)
C
      N = LEN(STRING)
      DO 10 I=N,1,-1
         IF (STRING(I:I) .NE. ' ') THEN
            LENSTR = I
            RETURN
         END IF
10    CONTINUE
C
      LENSTR = 0
      END
