% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pqtl3dplotly.R
\name{pqtl3dplotly}
\alias{pqtl3dplotly}
\title{3D pQTL plot}
\usage{
pqtl3dplotly(d, chrlen = gap::hg19, zmax = 300)
}
\arguments{
\item{d}{Data in pqtl2d() format.}

\item{chrlen}{Lengths of chromosomes for specific build: hg18, hg19, hg38.}

\item{zmax}{Maximum -log10p to truncate, above which they would be set to this value.}
}
\value{
A plotly figure.
}
\description{
3D pQTL plot
}
\examples{

\dontrun{
INF <- Sys.getenv("INF")
d <- read.csv(file.path(INF,"work","INF1.merge.cis.vs.trans"),as.is=TRUE)
r <- pqtl3dplotly(d,zmax=300)
htmlwidgets::saveWidget(r,file=file.path(INF,"INF1.pqtl3dplotly.html"))
r
}
}
