% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pedtodot_verbatim.R
\name{pedtodot_verbatim}
\alias{pedtodot_verbatim}
\title{Pedigree-drawing with graphviz}
\usage{
pedtodot_verbatim(f, run = FALSE, toDOT = FALSE, ...)
}
\arguments{
\item{f}{A data.frame containing pedigrees, each with pedigree id, individual id, father id, mother id, sex and affection status.}

\item{run}{A flag to run dot/neato on the generated .dot file(s).}

\item{toDOT}{A flag to generate script for DOT::dot().}

\item{...}{Other flag(s) for DOT::dot().}
}
\value{
No value is returned but outputs in .dot, .pdf, and .svg.
}
\description{
Read a GAS or LINKAGE format pedigree, return a digraph in the dot language and optionally
call dot/neato to make pedigree drawing.
}
\details{
This is a verbatim translation of the original pedtodot implemneted in Bash/awk in contrast to `pedtodot` which was largely a mirror.
To check independently, try `xsel -i < <(cat pedtodot_verbatim.R)` or `cat pedtodot_verbatim.R | xsel -i` and paste into an R session.
}
\note{
Adapted from Bash/awk script by David Duffy
}
\examples{
\dontrun{
# the pedigree in pedtodot as p2
  f <- read.table("p2")
  pedtodot_verbatim(f)
}
}
