% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describeChips.R
\name{describeChips}
\alias{describeChips}
\title{describeChips}
\usage{
describeChips(
  folder,
  extension = ".tif",
  mode = "All",
  subSample = TRUE,
  numChips = 200,
  numChipsBack = 200,
  subSamplePix = TRUE,
  sampsPerChip = 100
)
}
\arguments{
\item{folder}{Full folder path or folder path relative to the current working
directory that holds the image chips and associated masks. You must include
the final forward slash in the folder path (e.g., "C:/data/chips/").}

\item{extension}{Raster file extension (e.g., ".tif", ".png", ".jpeg", or ".img").
The utilities in this package generate files in ".tif" format, so this is the default.
This option is provided if chips are generated using another method.}

\item{mode}{Either "All", "Positive", or "Divided". This should match the settings
used in the makeChips() function or be set to "All" if makeChipsMultiClass() is
used. Default is "All".}

\item{subSample}{TRUE or FALSE. Whether or not to subsample the image chips to
calculate the summary metrics. We recommend using a subset if a large set of
chips are being summarized to reduce computational load. The default is TRUE.}

\item{numChips}{If subSample is set to TRUE, this parameter defines the
number of chips to subset. The default is 200. This parameter will be ignored
if subSample is set to FALSE.}

\item{numChipsBack}{If subSample is set to TRUE and the mode is "Divided", this
parameter indicates the number of chips to sample from the background-only
samples. The default is 200. This parameter will be ignored if subSample is
set to FALSE and/or mode is not "Divided".}

\item{subSamplePix}{TRUE or FALSE. Whether or not to calculate statistics using
a subsample of pixels from each image chip as opposed to all pixels. If a large
number of chips are available and/or each chip is large, we suggest setting this
argument to TRUE to reduce the computational load. The default is TRUE.}

\item{sampsPerChip}{If subSamplePix is TRUE, this parameters specifies the
number of random pixels to sample per chip. The default is 100. If
subSamplePix is set to FALSE, this parameter is ignored.}
}
\value{
List object containing the summary metrics for each band in the
$ImageStats object and the count of pixels by class in the $maskStats object.
}
\description{
Generate data frame of band summary statistics and class pixel counts
}
\details{
This function generates a set of summary metrics from image chips and
associated masks stored in a directory. For each band, the minimum, median, mean,
maximum, and standard deviation are returned (along with some other metrics). For
mask data, the count of pixels in each class are returned. These summarizations
can be useful for data normalization and determining class weightings in loss
calculations.
}
\examples{
\dontrun{
chpDescript <- describeChips(folder= "PATH TO CHIPS FOLDER",
                             extension = ".tif",
                             mode = "Positive",
                             subSample = TRUE,
                             numChips = 100,
                             numChipsBack = 100,
                             subSamplePix = TRUE,
                             sampsPerChip = 400)
}
}
