% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getType.R
\name{getType}
\alias{getType}
\alias{getType,ANY-method}
\alias{getType,geom-method}
\alias{getType,Spatial-method}
\alias{getType,sf-method}
\alias{getType,Raster-method}
\alias{getType,matrix-method}
\title{Get the type of a spatial object.}
\usage{
\S4method{getType}{ANY}(x)

\S4method{getType}{geom}(x)

\S4method{getType}{Spatial}(x)

\S4method{getType}{sf}(x)

\S4method{getType}{Raster}(x)

\S4method{getType}{matrix}(x)
}
\arguments{
\item{x}{the object for which to determine the type.}
}
\value{
A vector of two values of the geometry type (point/line/polygon/grid)
  and the specific main type/class of \code{x}.
}
\description{
Get the type of a spatial object.
}
\examples{
getType(x = gtGeoms$point)

getType(x = gtSP$SpatialPolygons)

getType(x = gtSF$multiline)

getType(x = gtRasters$categorical)

getType(x = matrix(0, 3, 5))
}
\seealso{
Other getters: 
\code{\link{getCRS}()},
\code{\link{getCols}()},
\code{\link{getExtent}()},
\code{\link{getFeatures}()},
\code{\link{getGroups}()},
\code{\link{getHistory}()},
\code{\link{getLayers}()},
\code{\link{getNames}()},
\code{\link{getPoints}()},
\code{\link{getRes}()},
\code{\link{getRows}()},
\code{\link{getWindow}()}
}
\concept{getters}
