% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geos-unary-geometry.R
\name{geos_delaunay_triangles}
\alias{geos_delaunay_triangles}
\alias{geos_delaunay_edges}
\alias{geos_voronoi_polygons}
\alias{geos_voronoi_edges}
\title{Delaunay triagulations and Voronoi diagrams}
\usage{
geos_delaunay_triangles(geom, tolerance = 0)

geos_delaunay_edges(geom, tolerance = 0)

geos_voronoi_polygons(geom, env = NULL, tolerance = 0)

geos_voronoi_edges(geom, env = NULL, tolerance = 0)
}
\arguments{
\item{geom}{A \link[=as_geos_geometry]{GEOS geometry vector} whose nodes will be used
as input.}

\item{tolerance}{A snapping tolerance or 0 to disable snapping}

\item{env}{A boundary for the diagram, or \code{NULL} to construct one
based on the input}
}
\value{
A \link[=as_geos_geometry]{GEOS geometry vector} of length \code{geom}
}
\description{
These functions return one triangulation/diagram per feature as a
multi geometry. These functions are not vectorized along their parameters.
}
\examples{
geos_delaunay_triangles("MULTIPOINT (0 0, 1 0, 0 1)")
geos_delaunay_edges("MULTIPOINT (0 0, 1 0, 0 1)")

geos_voronoi_polygons("MULTIPOINT (0 0, 1 0, 0 1)")
geos_voronoi_edges("MULTIPOINT (0 0, 1 0, 0 1)")

}
