% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geos-join.R
\name{geos_inner_join}
\alias{geos_inner_join}
\alias{geos_inner_join_keys}
\title{Generate inner join keys based on a GEOS predicate}
\usage{
geos_inner_join(
  x,
  y,
  predicate = "intersects",
  distance = NA,
  suffix = c(".x", ".y")
)

geos_inner_join_keys(x, y, predicate = "intersects", distance = NA)
}
\arguments{
\item{x, y}{Geometry vectors with a \code{\link[wk:wk_handle]{wk::wk_handle()}} method.}

\item{predicate}{One of:
\itemize{
\item intersects
\item contains
\item contains_properly
\item covered_by
\item covers
\item crosses
\item equals
\item equals_exact
\item intersects
\item within_distance
\item overlaps
\item touches
}}

\item{distance}{Passed to \code{\link[=geos_is_within_distance]{geos_is_within_distance()}} when \code{predicate}
is "within_distance"; passed to \code{\link[=geos_equals_exact]{geos_equals_exact()}} when \code{predicate}
is "equals_exact.}

\item{suffix}{A character vector of length 2 with suffixes for the left
and right sides for output columns with duplicated names.}
}
\value{
A data.frame with columns x and y corresponding to the 1-based
indices on pairs of \code{x} and \code{y} for which \code{predicate} is TRUE.
}
\description{
Experimental low-level spatial join infrastructure based on the
\code{\link[=geos_basic_strtree]{geos_basic_strtree()}}.
}
\examples{
x <- data.frame(
  col_x = "a",
  geometry = as_geos_geometry("POINT (10 10)")
)

y <- data.frame(
  col_y = "a",
  geometry = as_geos_geometry("POLYGON ((0 0, 0 10, 10 10, 10 0, 0 0))")
)

geos_inner_join(x, y, "intersects")

geos_inner_join_keys(
  "POINT (5 5)",
  "POLYGON ((0 0, 0 10, 10 10, 10 0, 0 0))",
  "intersects"
)

}
