% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_with_metadata.R
\name{reverse_quality_if_needed}
\alias{reverse_quality_if_needed}
\title{Reverse qualities if needed (\code{\link[=merge_methylation_with_metadata]{merge_methylation_with_metadata()}} helper)}
\usage{
reverse_quality_if_needed(quality_vector, direction_vector)
}
\arguments{
\item{quality_vector}{\verb{character vector}. The qualities to be reversed. See \code{\link{fastq_quality_scores}} for an explanation of quality scores.}

\item{direction_vector}{\verb{character vector}. Whether each sequence is forward or reverse. Must contain only \code{"forward"} and \code{"reverse"}, but is not case sensitive. Must be the same length as \code{sequence_vector}.}
}
\value{
\verb{character vector}. A vector of all forward versions of the input quality vector.
}
\description{
This function takes a vector of FASTQ qualities and a vector of directions
(which must all be either \code{"forward"} or \code{"reverse"}, \emph{not} case-sensitive)
and returns a vector of forward qualities.\cr\cr
Qualities of reads that were forward to begin with are unchanged,
while qualities of reads that were reverse are now flipped
to give the corresponding forward quality scores.\cr\cr
Called by \code{\link[=merge_methylation_with_metadata]{merge_methylation_with_metadata()}} to create a forward dataset,
alongside \code{\link[=reverse_sequence_if_needed]{reverse_sequence_if_needed()}}, \code{\link[=reverse_locations_if_needed]{reverse_locations_if_needed()}},
and \code{\link[=reverse_probabilities_if_needed]{reverse_probabilities_if_needed()}}.
}
\examples{
reverse_quality_if_needed(
    quality_vector = c("#^$&$*", "#^$&$*"),
    direction_vector = c("reverse", "forward")
)

}
