% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout-chain-circle-switch.R
\name{circle_switch}
\alias{circle_switch}
\title{Determine the active context of circle layout}
\usage{
circle_switch(radial = waiver(), direction = NULL, what = waiver(), ...)
}
\arguments{
\item{radial}{A \code{\link[=coord_circle]{coord_circle()}}/\code{\link[ggplot2:coord_radial]{coord_radial()}}
object that defines the global parameters for coordinate across all plots
in the layout. The parameters \code{start}, \code{end}, \code{direction}, and \code{expand} will
be inherited and applied uniformly to all plots within the layout. The
parameters \code{theta} and \code{r.axis.inside} will always be ignored and will be set
to \code{"x"} and \code{TRUE}, respectively, for all plots.}

\item{direction}{A single string of \code{"inward"} or \code{"outward"},
indicating the direction in which the plot is added.
\itemize{
\item \code{outward}: The plot is added from the inner to the outer.
\item \code{inward}: The plot is added from the outer to the inner.
}}

\item{what}{What should get activated for the \code{\link[=circle_layout]{circle_layout()}}?
A single number or string of the plot elements in the layout. If \code{NULL}, will remove any active context.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
A \code{circle_switch} object which can be added to \code{\link[=circle_layout]{circle_layout()}}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\examples{
set.seed(123)
small_mat <- matrix(rnorm(56), nrow = 7)
rownames(small_mat) <- paste0("row", seq_len(nrow(small_mat)))
colnames(small_mat) <- paste0("column", seq_len(ncol(small_mat)))
circle_discrete(small_mat) +
    ggalign() +
    geom_tile(aes(y = .column_index, fill = value)) +
    scale_fill_viridis_c() +
    align_dendro(aes(color = branch), k = 3L) +
    scale_color_brewer(palette = "Dark2")
}
