% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configure_inset.R
\name{configure_inset}
\alias{configure_inset}
\title{Configure transformations underpinning a map inset}
\usage{
configure_inset(
  centre = NULL,
  scale = NULL,
  translation = NULL,
  radius = NULL,
  units = "km",
  feature_type = NA
)
}
\arguments{
\item{centre}{Coordinates of the inset centre. Can instead be the name of a
geographic feature if \code{feature_type} is also provided.}

\item{scale}{Zoom scale: values larger than one will make the circle bigger.}

\item{translation}{Translate (shift) the inset. This can be an
\code{st_point} or simply a vector of length 2 containing the x and y
offsets respectively.}

\item{radius}{Radius of the inset circle.}

\item{units}{Base length unit (e.g. \code{"km"} or \code{"mi"}).
See \code{\link[ggmapinset:configure_inset]{ggmapinset::configure_inset()}} for supported values.}

\item{feature_type}{Type of map feature. See \code{\link[cartographer:feature_types]{feature_types()}} for a list of
registered types. If \code{NA}, the type is guessed based on the values in
\code{feature_names}.}
}
\value{
An inset configuration object.
}
\description{
This specialises \code{\link[ggmapinset:configure_inset]{ggmapinset::configure_inset()}} to allow the \code{centre}
to be specified as a location. The centroid of that location is used as the
inset's centre.
}
\examples{
cfg <- configure_inset(
  centre = "Yancey",
  feature_type = "sf.nc",
  scale = 2,
  translation = c(70, -180),
  radius = 50,
  units = "mi"
)
}
\seealso{
ggmapinset::configure_inset
}
