% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_freqpoly_interactive.R,
%   R/geom_histogram_interactive.R
\name{geom_freqpoly_interactive}
\alias{geom_freqpoly_interactive}
\alias{geom_histogram_interactive}
\title{Create interactive histograms and frequency polygons}
\usage{
geom_freqpoly_interactive(...)

geom_histogram_interactive(...)
}
\arguments{
\item{...}{arguments passed to base function,
plus any of the \link{interactive_parameters}.}
}
\description{
The geometries are based on \code{\link[ggplot2:geom_histogram]{ggplot2::geom_histogram()}}
and \code{\link[ggplot2:geom_histogram]{ggplot2::geom_freqpoly()}}.
See the documentation for those functions for more details.

This interactive version is only providing a single tooltip per
group of data (same for \code{data_id}). It means it is only possible
to associate a single tooltip to a set of bins.
}
\section{Details for interactive geom functions}{

The interactive parameters can be supplied with two ways:
\itemize{
\item As aesthetics with the mapping argument (via \code{\link[ggplot2:aes]{ggplot2::aes()}}).
In this way they can be mapped to data columns and apply to a set of geometries.

\item As plain arguments into the geom_*_interactive function.
In this way they can be set to a scalar value.
}
}

\examples{
# add interactive histogram -------
library(ggplot2)
library(ggiraph)

p <- ggplot(diamonds, aes(carat)) +
  geom_histogram_interactive(
    bins = 30,
    aes(tooltip = after_stat(count), group = 1L)
  )
x <- girafe(ggobj = p)
if (interactive()) {
  print(x)
}

p <- ggplot(diamonds, aes(price, colour = cut, tooltip = cut, data_id = cut)) +
  geom_freqpoly_interactive(binwidth = 500)
x <- girafe(ggobj = p)
x <- girafe_options(x = x, opts_hover(css = "stroke-width:3px;"))
if (interactive()) {
  print(x)
}
}
\seealso{
\code{\link[=girafe]{girafe()}}
}
