% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geocode.R
\name{geocode}
\alias{geocode}
\alias{mutate_geocode}
\alias{geocodeQueryCheck}
\alias{geocode_cache}
\alias{write_geocode_cache}
\alias{load_geocode_cache}
\alias{clear_geocode_cache}
\title{Geocode}
\usage{
geocode(
  location,
  output = c("latlon", "latlona", "more", "all"),
  source = c("google", "dsk"),
  force = ifelse(source == "dsk", FALSE, TRUE),
  urlonly = FALSE,
  override_limit = FALSE,
  nameType = c("long", "short"),
  ext = "com",
  inject = "",
  ...
)

mutate_geocode(data, location, ...)

geocodeQueryCheck()

geocode_cache()

write_geocode_cache(path, ...)

load_geocode_cache(path, overwrite = FALSE)

clear_geocode_cache(path)
}
\arguments{
\item{location}{a character vector of street addresses or place names (e.g.
\verb{"1600 pennsylvania avenue, washington dc" or "Baylor University"})}

\item{output}{amount of output, \code{"latlon"}, \code{"latlona"}, \code{"more"}, or \code{"all"}}

\item{source}{"google" for Google (note: "dsk" is defunct)}

\item{force}{force online query even if cached.}

\item{urlonly}{return only the url?}

\item{override_limit}{override the current query rate}

\item{nameType}{in some cases, Google returns both a long name and a short
name. this parameter allows the user to specify which to grab.}

\item{ext}{top level domain (e.g. "com", "co.nz"); helpful for non-US users}

\item{inject}{character string to add to the url or named character vector of
key-value pairs to be injected (e.g. c("a" = "b") get converted to "a=b"
and appended to the query)}

\item{...}{In \code{\link[=mutate_geocode]{mutate_geocode()}}, arguments to pass to \code{\link[=geocode]{geocode()}}. In
\code{\link[=write_geocode_cache]{write_geocode_cache()}}, arguments to pass to \code{\link[=saveRDS]{saveRDS()}}.}

\item{data}{a data frame or equivalent}

\item{path}{path to file}

\item{overwrite}{in \code{\link[=load_geocode_cache]{load_geocode_cache()}}, should the current cache be
wholly replaced with the one on file?}
}
\value{
If \code{output} is \code{"latlon"}, \code{"latlona"}, or \code{"more"}, a tibble
(classed data frame). If \code{"all"}, a list.
}
\description{
Geocodes (finds latitude and longitude of) a location using the Google
Geocoding API. Note: To use Google's Geocoding API, you must first enable the
API in the Google Cloud Platform Console. See \code{\link[=register_google]{register_google()}}.
}
\details{
Note: \code{\link[=geocode]{geocode()}} uses Google's Geocoding API to geocode addresses. Please
take care not to disclose sensitive information.
\verb{https://pmc.ncbi.nlm.nih.gov/articles/PMC8972108/} suggest various
alternative options for such data.
}
\examples{

\dontrun{ requires Google API key, see ?register_google

## basic usage
########################################

# geocoding is most commonly used for addresses
geocode("1600 Amphitheatre Parkway, Mountain View, CA")
geocode("1600 Amphitheatre Parkway, Mountain View, CA", urlonly = TRUE)

# google can also geocode colloquial names of places
geocode("the white house")

# geocode can also accept character vectors of places
geocode(c("the white house", "washington dc"))



## types of output
########################################

geocode("waco texas")
geocode("waco texas", output = "latlona")
geocode("waco texas", output = "more")
str(geocode("waco texas", output = "all"))

geocode(c("waco, texas", "houston, texas"))
geocode(c("waco, texas", "houston, texas"), output = "latlona")
geocode(c("waco, texas", "houston, texas"), output = "all") \%>\% str(4)



## mutate_geocode
########################################

# mutate_geocode is used to add location columns to an existing dataset
# that has location information

df <- data.frame(
  address = c("1600 Pennsylvania Avenue, Washington DC", "", "houston texas"),
  stringsAsFactors = FALSE
)

mutate_geocode(df, address)
df \%>\% mutate_geocode(address)


## known issues
########################################

# in some cases geocode finds several locations


}


}
\seealso{
\url{https://developers.google.com/maps/documentation/geocoding},
\url{https://developers.google.com/maps/documentation/javascript/geocoding},
\url{https://developers.google.com/maps/documentation/geocoding/usage-and-billing}
}
\author{
David Kahle \email{david@kahle.io}
}
