% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gkwfit.R
\name{print.gkwfit}
\alias{print.gkwfit}
\title{Print Method for gkwfit Objects}
\usage{
\method{print}{gkwfit}(x, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{x}{An object of class \code{"gkwfit"}, typically the result of a call to \code{\link{gkwfit}}.}

\item{digits}{Integer; the minimum number of significant digits to be printed in values.
Defaults to \code{max(3, getOption("digits") - 3)}.}

\item{...}{Additional arguments passed to underlying print methods (currently unused).}
}
\value{
Invisibly returns the original input object \code{x}. Called for its side effect of printing to the console.
}
\description{
Prints a concise summary of a model fitted by the \code{\link{gkwfit}} function,
displaying the call, estimated coefficients, log-likelihood, AIC, BIC,
number of observations, and a convergence warning if applicable.
}
\examples{
\donttest{
# Generate a small sample from Kumaraswamy distribution
set.seed(2203)
y <- rkw(50, alpha = 2.5, beta = 1.5)

# Fit the model with minimal options for speed
fit <- gkwfit(data = y, family = "kw", plot = FALSE, silent = TRUE)

# Print method displays concise model summary
print(fit)

# Alternative: object prints automatically when returned
fit
}

}
\seealso{
\code{\link{gkwfit}}, \code{\link{summary.gkwfit}}
}
\author{
Lopes, J. E.
}
\keyword{internal}
\keyword{methods}
