% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gkwreg-other-methods.R
\name{getCall.gkwreg}
\alias{getCall.gkwreg}
\title{Get Call from GKw Regression Model}
\usage{
\method{getCall}{gkwreg}(x, ...)
}
\arguments{
\item{x}{An object of class \code{"gkwreg"}.}

\item{...}{Currently not used.}
}
\value{
The matched call.
}
\description{
Extracts the call that was used to fit a Generalized Kumaraswamy regression
model.
}
\examples{
\donttest{
data(GasolineYield)
fit <- gkwreg(yield ~ batch + temp, data = GasolineYield, family = "kw")
getCall(fit)
}

}
\seealso{
\code{\link{gkwreg}}, \code{\link{update.gkwreg}}
}
\author{
Lopes, J. E.
}
