% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count-mono.R
\name{count_mono}
\alias{count_mono}
\alias{count_mono.glyrepr_composition}
\alias{count_mono.glyrepr_structure}
\title{Get the Number of Monosaccharides}
\usage{
count_mono(x, mono = NULL)

\method{count_mono}{glyrepr_composition}(x, mono = NULL)

\method{count_mono}{glyrepr_structure}(x, mono = NULL)
}
\arguments{
\item{x}{A glycan composition (\code{glyrepr_composition}) or
a glycan structure (\code{glyrepr_structure}) vector}

\item{mono}{The monosaccharide to count. A character scalar.
If \code{NULL} (default), return the total number of monosaccharides.}
}
\value{
A numeric vector of the same length as \code{x}.
}
\description{
Get the number of monosaccharides in a glycan composition or glycan structure.
When \code{mono} is "generic" (e.g. "Hex", "HexNAc"),
it counts all "concrete" monosaccharides that match.
For example, "Hex" will count all Glc, Man, Gal, etc.
When \code{mono} is "concrete" (e.g. "Gal", "GalNAc"),
NA is returned when the composition is "generic".
}
\examples{
comp <- glycan_composition(c(Hex = 5, HexNAc = 2), c(Gal = 1, Man = 1, GalNAc = 1))
count_mono(comp, "Hex")
count_mono(comp, "Gal")

struct <- as_glycan_structure("Gal(b1-3)GlcNAc(b1-4)Glc(a1-")
count_mono(struct, "Gal")

# Total number of monosaccharides
count_mono(comp)

}
