% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{euromone}
\alias{euromone}
\title{Euro area macroeconomic data used in Virolainen (2022)}
\format{
A numeric matrix of class \code{'ts'} with 276 rows and 4 columns with one time series in each column:
\describe{
  \item{First column (IPI):}{The cyclical component of the log of industrial production index,
    url is https://sdw.ecb.europa.eu/quickview.do?SERIES_KEY=132.STS.M.I8.Y.PROD.NS0010.4.000.}
  \item{Second column (HCPI):}{The log-difference of harmonized consumer price index,
    url is https://sdw.ecb.europa.eu/quickview.do?SERIES_KEY=122.ICP.M.U2.Y.000000.3.INX.}
  \item{Third column (OIL):}{The log-difference of Brent crude oil price (Europe),
    \url{https://fred.stlouisfed.org/series/MCOILBRENTEU}.}
  \item{Third column (RATE):}{The EONIA from January 1999 to October 2008 and after that the Wu and Xia (2016) shadow rate,
    urls are https://sdw.ecb.europa.eu/quickview.do?SERIES_KEY=143.FM.M.U2.EUR.4F.MM.EONIA.HSTA and
    \url{https://sites.google.com/view/jingcynthiawu/shadow-rates}.}
}
}
\source{
The Federal Reserve Bank of St. Louis database and the Federal Reserve Bank of Atlanta's website
}
\usage{
euromone
}
\description{
A monthly Euro area data covering the period from January 1999 to December 2021 (276 observations) and consisting four variables:
cyclical component of log industrial production index, the log-difference of harmonized consumer price index, the log-difference
of Brent crude oil prices (Europe), and an interest rate variable. The interest rate variable is the Euro overnight index average
rate (EONIA) from January 1999 to October 2008, and after that the Wu and Xia (2016) shadow rate, which is not constrained by the zero lower
bound and also quantifies unconventional monetary policy measures. The log-difference of the harmonized consumer price index is
multiplied by hundred and the log-difference of oil price by ten. This data is the one that was used in Virolainen (2022).

The cyclical component of the log of industrial production index was obtained by applying the linear projection filter proposed
by Hamilton (2018) using the parameter values h=24 and p=12. In order to obtain as accurate estimates as possible, we applied the
filter to the full available sample from January 1991 to December 2021 before extracting our sample period from it.
package lpirfs (Adämmer, 2021).
}
\references{
\itemize{
   \item Virolainen S. 2022. Gaussian and Student's t mixture vector autoregressive model with application to the
     asymmetric effects of monetary policy shocks in the Euro area. Unpublished working
     paper, available as arXiv:2109.13648.
   \item Wu J. and Xia F. 2016. Measuring the macroeconomic impact of monetary policy at the zero lower bound.
     \emph{Journal of Money, Credit and Banking}, 48(2-3): 253-291.
 }
}
\keyword{datasets}
