% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est.USVT.R
\name{est.USVT}
\alias{est.USVT}
\title{Estimate graphons based via Universal Singular Value Thresholding}
\usage{
est.USVT(A, eta = 0.01)
}
\arguments{
\item{A}{either \describe{
\item{Case 1.}{an \eqn{(n\times n)} binary adjacency matrix, or}
\item{Case 2.}{a list containing multiple of \eqn{(n\times n)} binary adjacency matrices.}
}}

\item{eta}{a positive number in \eqn{(0,1)} to control the level of thresholding.}
}
\value{
a named list containing
\describe{
\item{svs}{a vector of sorted singular values.}
\item{thr}{a threshold to disregard singular values.}
\item{P}{a matrix of estimated edge probabilities.}
}
}
\description{
\code{est.USVT} is a generic matrix estimation method first
proposed for the case where a noisy realization of the matrix is given.
Universal Singular Value Thresholding (USVT), as its name suggests,
utilizes singular value decomposition of observations in addition to
thresholding over singular values achieved from the decomposition.
}
\examples{
## generate a graphon of type No.1 with 3 clusters
W = gmodel.preset(3,id=1)

## create a probability matrix for 100 nodes
graphW = gmodel.block(W,n=100)
P = graphW$P

## draw 5 observations from a given probability matrix
A = gmodel.P(P,rep=5,symmetric.out=TRUE)

## run USVT algorithm with different eta values (0.01,0.1)
res2 = est.USVT(A,eta=0.01)
res3 = est.USVT(A,eta=0.1)

## compare true probability matrix and estimated ones
opar = par(no.readonly=TRUE)
par(mfrow=c(1,3), pty="s")
image(P,      main="original P matrix")
image(res2$P, main="USVT with eta=0.01")
image(res3$P, main="USVT with eta = 0.1")
par(opar)

}
\references{
\insertRef{Chatterjee2015}{graphon}
}
