% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmeans.R
\name{kmeans}
\alias{kmeans}
\alias{.kmeans}
\alias{.kmeans.ppp}
\title{Extension of \link[stats]{kmeans}}
\usage{
.kmeans(x, formula, ...)

\method{.kmeans}{ppp}(
  x,
  formula,
  centers = as.integer(ceiling((x[["n"]]/clusterSize))),
  clusterSize,
  ...
)
}
\arguments{
\item{x}{see \strong{Usage}}

\item{formula}{\link[stats]{formula}}

\item{...}{additional parameters of function \link[stats]{kmeans}}

\item{centers}{\link[base]{integer} scalar, number of clusters \eqn{k}, see function \link[stats]{kmeans}}

\item{clusterSize}{\link[base]{integer} scalar, number of points per cluster}
}
\value{
Function \code{\link[=.kmeans]{.kmeans()}} returns a \link[stats]{kmeans} object.
}
\description{
Extension of \link[stats]{kmeans}
}
\keyword{internal}
