% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{remove_suffix}
\alias{remove_suffix}
\title{Remove suffix from sample names}
\usage{
remove_suffix(dat, suffix)
}
\arguments{
\item{dat}{List object, containing at least two matrices "intensity" and "theta".}

\item{suffix}{Vector of  character (e.g. "_Grn" or "Red").}
}
\value{
List with two matrices "intensity" (signal intensities) and "theta" (genotype value).
}
\description{
Remove suffix from sample names
}
\examples{
if(require(brassicaData)){
data(raw_napus, package = "brassicaData")
\dontshow{
raw_napus <- filt_samp(raw_napus, raw_napus$samples[-(1:10)])
raw_napus <- filt_snps(raw_napus, raw_napus$snps[-(1:10)])
}
dat <- intens_theta(raw_napus)
dat <- remove_suffix(dat, "_Grn")
}
}

