% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_column_hide.R
\name{modify_column_hide}
\alias{modify_column_hide}
\alias{modify_column_unhide}
\title{Modify hidden columns}
\usage{
modify_column_hide(x, columns)

modify_column_unhide(x, columns)
}
\arguments{
\item{x}{(\code{gtsummary})\cr
gtsummary object}

\item{columns}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Selector of columns in \code{x$table_body}}
}
\description{
Use these functions to hide or unhide columns in a gtsummary table.
Use \code{show_header_names(show_hidden=TRUE)} to print available columns to update.
}
\examples{
# Example 1 ----------------------------------
# hide 95\% CI, and replace with standard error
lm(age ~ marker + grade, trial) |>
  tbl_regression() |>
  modify_column_hide(conf.low) |>
  modify_column_unhide(columns = std.error)
}
\author{
Daniel D. Sjoberg
}
