% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hanr_rtad.R
\name{hanr_rtad}
\alias{hanr_rtad}
\title{Anomaly and change point detector using RTAD}
\usage{
hanr_rtad(sw_size = 30, noise = 0.001, trials = 5, sigma = sd)
}
\arguments{
\item{sw_size}{sliding window size (default 30)}

\item{noise}{noise}

\item{trials}{trials}

\item{sigma}{function to compute the dispersion}
}
\value{
\code{hanr_rtad} object
}
\description{
Anomaly and change point detection using RTAD
The RTAD model adjusts to the time series. Observations distant from the model are labeled as anomalies.
It wraps the EMD model presented in the hht library.
}
\examples{
library(daltoolbox)
library(zoo)

#loading the example database
data(examples_anomalies)

#Using simple example
dataset <- examples_anomalies$simple
head(dataset)

# setting up time series emd detector
model <- hanr_rtad()

# fitting the model
model <- fit(model, dataset$serie)

detection <- detect(model, dataset$serie)

# filtering detected events
print(detection[(detection$event),])

}
