/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
#ifndef H5FDonion_H
#define H5FDonion_H
#define H5FD_ONION (H5FDperform_init(H5FD_onion_init))
#define H5FD_ONION_VALUE H5_VFD_ONION
#define H5FD_ONION_FAPL_INFO_VERSION_CURR 1
#define H5FD_ONION_FAPL_INFO_CREATE_FLAG_ENABLE_PAGE_ALIGNMENT                                               \
    (0x0001u)
#define H5FD_ONION_FAPL_INFO_COMMENT_MAX_LEN 255
#define H5FD_ONION_FAPL_INFO_REVISION_ID_LATEST UINT64_MAX
typedef enum H5FD_onion_target_file_constant_t {
    H5FD_ONION_STORE_TARGET_ONION,
} H5FD_onion_target_file_constant_t;
typedef struct H5FD_onion_fapl_info_t {
    uint8_t version;
    hid_t backing_fapl_id;
    uint32_t page_size;
    H5FD_onion_target_file_constant_t store_target;
    uint64_t revision_num;
    uint8_t force_write_open;
    uint8_t creation_flags;
    char comment[H5FD_ONION_FAPL_INFO_COMMENT_MAX_LEN +
                 1];
} H5FD_onion_fapl_info_t;
#ifdef __cplusplus
extern "C" {
#endif
H5_DLL hid_t H5FD_onion_init(void);
H5_DLL herr_t H5Pget_fapl_onion(hid_t fapl_id, H5FD_onion_fapl_info_t *fa_out);
H5_DLL herr_t H5Pset_fapl_onion(hid_t fapl_id, const H5FD_onion_fapl_info_t *fa);
H5_DLL herr_t H5FDonion_get_revision_count(const char *filename, hid_t fapl_id, uint64_t *revision_count);
#ifdef __cplusplus
}
#endif
#endif
