/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
#ifndef H5Ldevelop_H
#define H5Ldevelop_H
#include "H5Lpublic.h"
#define H5L_LINK_CLASS_T_VERS 1
#define H5L_EXT_VERSION 0
#define H5L_EXT_FLAGS_ALL 0
typedef herr_t (*H5L_create_func_t)(const char *link_name, hid_t loc_group, const void *lnkdata,
                                    size_t lnkdata_size, hid_t lcpl_id);
typedef herr_t (*H5L_move_func_t)(const char *new_name, hid_t new_loc, const void *lnkdata,
                                  size_t lnkdata_size);
typedef herr_t (*H5L_copy_func_t)(const char *new_name, hid_t new_loc, const void *lnkdata,
                                  size_t lnkdata_size);
typedef hid_t (*H5L_traverse_func_t)(const char *link_name, hid_t cur_group, const void *lnkdata,
                                     size_t lnkdata_size, hid_t lapl_id, hid_t dxpl_id);
typedef herr_t (*H5L_delete_func_t)(const char *link_name, hid_t file, const void *lnkdata,
                                    size_t lnkdata_size);
typedef ssize_t (*H5L_query_func_t)(const char *link_name, const void *lnkdata, size_t lnkdata_size,
                                    void *buf, size_t buf_size);
//! <!-- [H5L_class_t_snip] -->
typedef struct {
    int                 version;
    H5L_type_t          id;
    const char         *comment;
    H5L_create_func_t   create_func;
    H5L_move_func_t     move_func;
    H5L_copy_func_t     copy_func;
    H5L_traverse_func_t trav_func;
    H5L_delete_func_t   del_func;
    H5L_query_func_t    query_func;
} H5L_class_t;
//! <!-- [H5L_class_t_snip] -->
#ifdef __cplusplus
extern "C" {
#endif
H5_DLL herr_t H5Lregister(const H5L_class_t *cls);
H5_DLL herr_t H5Lunregister(H5L_type_t id);
#ifdef __cplusplus
}
#endif
#ifndef H5_NO_DEPRECATED_SYMBOLS
#define H5L_LINK_CLASS_T_VERS_0 0
typedef hid_t (*H5L_traverse_0_func_t)(const char *link_name, hid_t cur_group, const void *lnkdata,
                                       size_t lnkdata_size, hid_t lapl_id);
typedef struct {
    int                   version;
    H5L_type_t            id;
    const char           *comment;
    H5L_create_func_t     create_func;
    H5L_move_func_t       move_func;
    H5L_copy_func_t       copy_func;
    H5L_traverse_0_func_t trav_func;
    H5L_delete_func_t     del_func;
    H5L_query_func_t      query_func;
} H5L_class_0_t;
#endif
#endif
