% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{SocGrades}
\alias{SocGrades}
\title{Grades in a Sociology Course}
\format{
A data frame with 40 observations on the following 10 variables.
\describe{ 
  \item{\code{class}}{Social class, an ordered factor with levels
      \code{1} > \code{2} > \code{3}} 
  \item{\code{sex}}{sex, a factor with levels \code{F} \code{M}} 
  \item{\code{gpa}}{grade point average}
  \item{\code{boards}}{College Board test scores}
  \item{\code{hssoc}}{previous high school unit in sociology, a factor with 2 \code{no}, \code{yes}} 
  \item{\code{pretest}}{score on course pretest}
  \item{\code{midterm1}}{score on first midterm exam}
  \item{\code{midterm2}}{score on second midterm exam}
  \item{\code{final}}{score on final exam} 
  \item{\code{eval}}{course evaluation} }
}
\source{
Marascuilo, L. A. and Levin, J. R. (1983). \emph{Multivariate
Statistics in the Social Sciences} Monterey, CA: Brooks/Cole, Table 5-1, p.
192.
}
\description{
The data set \code{SocGrades} contains four outcome measures on student
performance in an introductory sociology course together with six potential
predictors. These data were used by Marascuilo and Levin (1983) for an
example of canonical correlation analysis, but are also suitable as examples
of multivariate multiple regression, MANOVA, MANCOVA and step-down analysis
in multivariate linear models.
}
\details{
\code{midterm1}, \code{midterm2}, \code{final}, and possibly \code{eval} are
the response variables. All other variables are potential predictors.

The factors \code{class}, \code{sex}, and \code{hssoc} can be used with
\code{as.numeric} in correlational analyses.
}
\examples{

data(SocGrades)
# basic MLM
grades.mod <- lm(cbind(midterm1, midterm2, final, eval) ~ 
	class + sex + gpa + boards + hssoc + pretest, data=SocGrades)
	
car::Anova(grades.mod, test="Roy")

clr <- c("red", "blue", "darkgreen", "magenta", "brown", "black", "darkgray")
heplot(grades.mod, col=clr)
pairs(grades.mod, col=clr)

\dontrun{
heplot3d(grades.mod, col=clr, wire=FALSE)
}

if (require(candisc)) {
	# calculate canonical results for all terms
	grades.can <- candiscList(grades.mod)
	# extract canonical R^2s
	unlist(lapply(grades.can, function(x) x$canrsq))
	# plot class effect in canonical space
	heplot(grades.can, term="class", scale=4)	

	# 1 df terms: show canonical scores and weights for responses
	plot(grades.can, term="sex")
	plot(grades.can, term="gpa")
	plot(grades.can, term="boards")
	}


}
\concept{MANOVA}
\concept{candisc}
\keyword{datasets}
