% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpmatrix.R
\name{summary.tpmatrix}
\alias{summary.tpmatrix}
\title{Summarize transition probability matrix}
\usage{
\method{summary}{tpmatrix}(object, id = NULL, probs = NULL, unflatten = FALSE, ...)
}
\arguments{
\item{object}{A \code{\link{tpmatrix}} object.}

\item{id}{A \code{\link{tpmatrix_id}} object for which columns contain the ID variables
for each row in \code{object}. If not \code{NULL}, then transition probability matrices
are summarized by the ID variables in \code{id}.}

\item{probs}{A numeric vector of probabilities with values in \verb{[0,1]} used
to compute quantiles. Computing quantiles can be slow when \code{object} is large,
so the default is \code{NULL}, meaning that no quantiles are computed.}

\item{unflatten}{If \code{FALSE}, then each column containing a summary statistic
is a vector and the generated table contains one row
(for each set of ID variables) for each possible transition; if
\code{TRUE}, then each column stores a list of \code{matrix} objects containing
transition probability matrices formed by "unflattening" the one-dimensional
vectors. See "Value" below for additional details.}

\item{...}{Additional arguments affecting the summary. Currently unused.}
}
\value{
If \code{unflatten = "FALSE"} (the default), then a \code{\link[data.table:data.table]{data.table::data.table}}
is returned with columns for (i) the health state that is being transitioned
from (\code{from}), (ii) the health state that is being transitioned to (\code{to})
(iii) the mean of each parameter across parameter samples (\code{mean}),
(iv) the standard deviation of the parameter samples (\code{sd}), and
(v) quantiles of the parameter samples corresponding to the \code{probs} argument.

If, on the other hand, \code{unflatten = "TRUE"}, then the parameters are unflattened
to form transition probability matrices; that is, the \code{mean}, \code{sd}, and
quantile columns are (lists of) matrices.

In both cases, if \code{id} is not \code{NULL}, then the ID variables are also
returned as columns.
}
\description{
Summarize a \code{\link{tpmatrix}} object storing transition probability matrices.
Summary statistics are computed for each possible transition.
}
\examples{
library("data.table")
hesim_dat <-  hesim_data(strategies = data.table(strategy_id = 1:2),
                                patients = data.table(patient_id = 1:3))
input_data <- expand(hesim_dat, by = c("strategies", "patients"))

# Summarize across all rows in "input_data"
p_12 <- ifelse(input_data$strategy_id == 1, .8, .6)
p <- tpmatrix(
  C, p_12,
  0, 1
)

## Summary where each column is a vector
summary(p)
summary(p, probs = c(.025, .975))

## Summary where each column is a matrix
ps <- summary(p, probs = .5, unflatten = TRUE)
ps
ps$mean

# Summarize by ID variables
tpmat_id <- tpmatrix_id(input_data, n_samples = 2) 
p_12 <- ifelse(tpmat_id$strategy_id == 1, .8, .6)
p <- tpmatrix(
  C, p_12,
  0, 1
)

## Summary where each column is a vector
summary(p, id = tpmat_id)

## Summary where each column is a matrix
ps <- summary(p, id = tpmat_id, unflatten = TRUE)
ps
ps$mean
}
