% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heuristics.R
\name{predictPairInternal}
\alias{predictPairInternal}
\title{Generic function to predict which of a pair of rows has a higher criterion.}
\usage{
predictPairInternal(object, row1, row2)
}
\arguments{
\item{object}{The object that implements predictPair, e.g. a ttb model.}

\item{row1}{The first row of cues (object$cols_to_fit columns), as a
one-row matrix.}

\item{row2}{The second row of cues.}
}
\value{
A number in the set {-1, 0, 1}, where 1 means row1 is predicted to
  have a greater criterion, -1 means row2 is greater, and 0 is a tie.
}
\description{
Do not call this directly (which is why it is called "internal").
Instead, call predictPair.  Heuristics implement this function in order to
be callable with predictPair.
}
\keyword{internal}

