% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{SIRImplausibility}
\alias{SIRImplausibility}
\title{Sample Implausibility Data}
\format{
A data frame with 1000 rows and 7 variables:
\describe{
  \item{aSI}{Infection: transition rate from S to I}
  \item{aIR}{Recovery: transition rate from I to R}
  \item{aSR}{Waning Immunity: transition rate from R to S}
  \item{nS}{Implausibility for nS}
  \item{nI}{Implausibility for nI}
  \item{nR}{Implausibility for nR}
  \item{I}{Maximum implausibility}
}
}
\usage{
SIRImplausibility
}
\description{
A dataset containing 1000 points from the region bounded by
[0.1, 0.8], [0, 0.5], [0, 0.05] for aSI, aIR and aSR respectively.
Implausibility has been calculated (for emulators trained on the
\code{\link{SIRSample}} training dataset) for each of the outputs
nS, nI, nR, and the maximum implausibility is included.
The target values used in calculating implausibility were:
\describe{
  \item{nS}{between 324 and 358}
  \item{nI}{mean 143 (sigma 7.15)}
  \item{nR}{between 490 and 542}
}
}
\keyword{datasets}
