% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid.R
\name{univariate_grid}
\alias{univariate_grid}
\title{Univariate Grid}
\usage{
univariate_grid(
  z,
  grid_size = 49L,
  trim = c(0.01, 0.99),
  strategy = c("uniform", "quantile")
)
}
\arguments{
\item{z}{A vector/factor.}

\item{grid_size}{Approximate grid size.}

\item{trim}{A non-discrete numeric variable is trimmed at these quantile
probabilities before calculations. Set to \code{c(0, 1)} for no trimming.}

\item{strategy}{How to find evaluation points of non-discrete numeric columns?
Either "uniform" (via \code{\link[=pretty]{pretty()}}) or "quantile", see description of
\code{\link[=univariate_grid]{univariate_grid()}}.}
}
\value{
A vector/factor of evaluation points.
}
\description{
Finds evaluation grid for any numeric or non-numeric vector \code{z}.

For discrete \code{z} (non-numeric, or numeric with at most \code{grid_size} unique values),
this is simply \code{sort(unique(z))}.

Otherwise, if \code{strategy = "uniform"} (default), the evaluation points are the
result of \code{\link[=pretty]{pretty()}} over the trimmed range of \code{z}.
If \code{strategy = "quantile"}, the evaluation points are computed
as quantiles over a regular grid of probabilities from \code{trim[1]} to \code{trim[2]}.
Set \code{trim = c(0, 1)} for no trimming.

Quantiles are calculated based on the inverse of the ECDF, i.e., with
\verb{stats::quantile(..., type = 1}).
}
\examples{
univariate_grid(iris$Species)
univariate_grid(rev(iris$Species))                       # Same

x <- iris$Sepal.Width
univariate_grid(x, grid_size = 5)                        # Quantile binning
univariate_grid(x, grid_size = 3, strategy = "uniform")  # Uniform pretty
}
\seealso{
\code{\link[=multivariate_grid]{multivariate_grid()}}
}
