% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/req-perform-connection.R
\name{StreamingBody}
\alias{StreamingBody}
\title{\code{StreamingBody} class}
\description{
\code{StreamingBody} class

\code{StreamingBody} class
}
\details{
This R6 class is used to represent the body of a streaming response.
When using this in mocked responses, you can either create a new instance
using your own connection or use a subclass for some other representation.
In either case, you will pass to the \code{body} argument of \code{\link[=new_response]{new_response()}}.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-StreamingBody-new}{\code{StreamingBody$new()}}
\item \href{#method-StreamingBody-read}{\code{StreamingBody$read()}}
\item \href{#method-StreamingBody-read_all}{\code{StreamingBody$read_all()}}
\item \href{#method-StreamingBody-is_open}{\code{StreamingBody$is_open()}}
\item \href{#method-StreamingBody-is_complete}{\code{StreamingBody$is_complete()}}
\item \href{#method-StreamingBody-get_fdset}{\code{StreamingBody$get_fdset()}}
\item \href{#method-StreamingBody-close}{\code{StreamingBody$close()}}
\item \href{#method-StreamingBody-clone}{\code{StreamingBody$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StreamingBody-new"></a>}}
\if{latex}{\out{\hypertarget{method-StreamingBody-new}{}}}
\subsection{Method \code{new()}}{
Create a new object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StreamingBody$new(conn)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{conn}}{A connection, that is open and ready for reading.
\code{StreamingBody} will take care of closing it.`}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StreamingBody-read"></a>}}
\if{latex}{\out{\hypertarget{method-StreamingBody-read}{}}}
\subsection{Method \code{read()}}{
Read \code{n} bytes into a raw vector.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StreamingBody$read(n)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Number of bytes to read}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StreamingBody-read_all"></a>}}
\if{latex}{\out{\hypertarget{method-StreamingBody-read_all}{}}}
\subsection{Method \code{read_all()}}{
Read all bytes and close the connection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StreamingBody$read_all(buffer = 32 * 1024)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{buffer}}{Buffer size, in bytes.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StreamingBody-is_open"></a>}}
\if{latex}{\out{\hypertarget{method-StreamingBody-is_open}{}}}
\subsection{Method \code{is_open()}}{
Is the connection still open?
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StreamingBody$is_open()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StreamingBody-is_complete"></a>}}
\if{latex}{\out{\hypertarget{method-StreamingBody-is_complete}{}}}
\subsection{Method \code{is_complete()}}{
Is the connection complete? (i.e. is there data remaining
to be read?)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StreamingBody$is_complete()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StreamingBody-get_fdset"></a>}}
\if{latex}{\out{\hypertarget{method-StreamingBody-get_fdset}{}}}
\subsection{Method \code{get_fdset()}}{
Get the active file descriptions and timeout from the
handle. Wrapper around \code{\link[curl:multi]{curl::multi_fdset()}}. Returns \code{NULL} if handle
not set.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StreamingBody$get_fdset()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StreamingBody-close"></a>}}
\if{latex}{\out{\hypertarget{method-StreamingBody-close}{}}}
\subsection{Method \code{close()}}{
Close the connection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StreamingBody$close()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StreamingBody-clone"></a>}}
\if{latex}{\out{\hypertarget{method-StreamingBody-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StreamingBody$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
