% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypsoFunc.R
\name{generateHypsoTables}
\alias{generateHypsoTables}
\title{Generating hypsometric tables}
\usage{
generateHypsoTables(x, y)
}
\arguments{
\item{x}{An object of class SpatialPolygonsDataFrame or simple features (sf).
For instance, you can use RGDAL package's "readOGR()" function to create such an object from Shapefiles saved on disk.
Alternatively, you can use sf's st_read() function to get a simple features object from the shapefile.
NB: at least one column (attribute) named 'Name' should be present in the shapefile or input data frame.}

\item{y}{An object of class RasterLayer. You can use the raster package to read GeoTIFF and other raster formats from disk.}
}
\value{
A list of length 2. The 1st element is a list of data frames, each representing the hypsometric tables for each sub-catchment.
    The 2nd element is a data frame with min & max elevation values for each sub-catchment.
}
\description{
This function accepts as input the DEM and sub-catchments boundaries and
pre-process this data  to extract the tables that are used to calculate the
hypsographic curves and integral of these sub-catchments.
}
\details{
The raster package's "crop()" and "mask()" functions are used to iteratively clip the DEM to each sub-catchment.
For each sub-cacthment, the elevation range is divided into 30 equidistant contours.
Then,  the "area()" function is used to calculate the areas between each contour.
}
\seealso{
\code{\link{crop}}

\code{\link{mask}}

\code{\link{classify}}
}
\author{
Faustin Gashakamba \email{gashakamba@gmail.com}
}
