% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rand.stg2.R
\name{rand.stg2}
\alias{rand.stg2}
\title{Stage 2 Adaptive Randomization}
\usage{
rand.stg2(dose, dose.tox, p1, p2, K, coh.size, m, v, N, stop.rule = 9,
  cohort = 1, samedose = TRUE, nbb = 100)
}
\arguments{
\item{dose}{number of doses to be tested (scalar)}

\item{dose.tox}{vector of true toxicities for each dose. Values range from 0 - 1.}

\item{p1}{toxicity under null (unsafe DLT rate). Values range from 0 - 1.}

\item{p2}{toxicity under alternative (safe DLT rate). Values range from 0 - 1; p1 > p2}

\item{K}{threshold for LR. Takes integer values: 1,2,...(recommended K=2)}

\item{coh.size}{cohort size (number of patients) per dose (Stage 1)}

\item{m}{vector of mean efficacies per dose. Values range from 0 - 100. 
(e.g, T cell persistence - values b/w 5 and 80 per cent)}

\item{v}{vector of efficacy variances per dose. Values range from 0 - 1. (e.g., 0.01)}

\item{N}{total sample size for stages 1&2}

\item{stop.rule}{if only dose 1 safe, allocate up to 9 (default) patients at dose 1 
to collect more info}

\item{cohort}{cohort size (number of patients) per dose (Stage 2). Default is 1.}

\item{samedose}{designates whether the next patient is allocated to the same dose 
as the previous patient. Default is TRUE. Function adjusts accordingly.}

\item{nbb}{binomial parameter (default = 100 cells per patient)}
}
\value{
List of the following objects:
\itemize{
\item Y.final - vector of all efficacy outcomes (Ys) corresponding to dose assignments 
(Stages 1&2)
\item d.final - vector of all dose assignments(Stages 1&2)
}
If dose allocation stops early, put NAs in d.final and y.final 
until it reaches the total sample size.
}
\description{
Function \code{rand.stg2()} fits a linear regression for the continuous 
efficacy outcomes,
computes the randomization probabilities/dose and allocates the next patient to a dose that
is considered acceptably safe and has the most promising efficacy. Dose safety is still 
monitored using LR and doses
that become unacceptable are discarded (never re-visited).
}
\examples{
# Number of pre-specified dose levels
dose <- 5
# Vector of true toxicities associated with each dose
dose.tox <- c(0.05, 0.10, 0.20, 0.35, 0.45)       
# Acceptable (p_yes) and unacceptable (p_no) DLT rates used for establishing safety
p_no <- 0.40                                     
p_yes <- 0.15    

# Likelihood-ratio (LR) threshold
K <- 2                                          

# Cohort size used in stage 1
coh.size <- 3 

# Vector of true mean efficacies per dose (here mean percent persistence per dose)
m <- c(5, 15, 40, 65, 80)   # MUST BE THE SAME LENGTH AS dose.tox                  

# Efficacy(equal) variance per dose
v <- rep(0.01, 5) 

# Total sample size (stages 1&2)                            
N <- 25                                        

# Stopping rule: if dose 1 is the only safe dose, allocate up to 9 pts.
stop.rule <- 9 

rand.stg2(dose, dose.tox, p_no, p_yes, K, coh.size, m, v, N, stop.rule = stop.rule, 
cohort = 1, samedose = TRUE, nbb = 100) 

}
