% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nTTP.indiv.sim.R
\name{nTTP.indiv.sim}
\alias{nTTP.indiv.sim}
\title{Simulate full trial (both stages) x times when using nTTP to measure toxicity}
\usage{
nTTP.indiv.sim(W, TOX, ntox, dose)
}
\arguments{
\item{W}{matrix defining burden weight of each grade level for all toxicity types. 
The dimensions are ntox rows by 5 columns (for grades 0-4).
See Ezzalfani et al. (2013) for details.}

\item{TOX}{matrix array of toxicity probabilities. There should be ntox matrices. 
Each matrix represents one toxicity type, where probabilities of each toxicity 
grade are specified across each dose. Each matrix has the same dimensions: 
n rows, representing number of doses, and 5 columns (for grades 0-4). 
Probabilities across each dose (rows) must sum to 1. See Ezzalfani et al. (2013) for details.}

\item{ntox}{number (integer) of different toxicity types}

\item{dose}{number of doses to be tested (scalar)}
}
\value{
List of the following objects:
\itemize{
\item sim.Y - estimated efficacy per each dose assignment 
\item sim.d - dose assignment for each patient in the trial 
}
}
\description{
Results are displayed in a matrix format, where each row represents one trial simulation
}
