# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Intraclass correlation used to assess variability of lower-order
#' relationships across higher-order processes/units.
#'
#' A function and vignettes for computing the intraclass correlation described
#' in Aguinis & Culpepper (2015). iccbeta quantifies the share of variance
#' in an outcome variable that is attributed to heterogeneity in slopes due to
#' higher-order processes/units.
#' 
#' @param X    The design `matrix` of fixed effects from a lmer model.
#' @param l2id A `vector` that identifies group membership. The vector
#'             must be coded as a sequence of integers from 1 to J,
#'             the number of groups.
#' @param T    A `matrix` of the estimated variance-covariance matrix of
#'             a lmer model fit.
#' @param vy   The variance of the outcome variable.
#' 
#' @return 
#' A `list` with:
#' 
#' - `J`
#' - `means`
#' - `XcpXc`
#' - `Nj`
#' - `rho_beta`
#' 
#' @author 
#' Steven Andrew Culpepper
#' 
#' @seealso 
#' 
#' [lme4::lmer()], [model.matrix()],
#' [lme4::VarCorr()], [RLRsim::LRTSim()],
#' [iccbeta::Hofmann], and [iccbeta::simICCdata]
#'          
#' @references
#' Aguinis, H., & Culpepper, S.A. (2015). An expanded decision making
#' procedure for examining cross-level interaction effects with multilevel
#' modeling. _Organizational Research Methods_. Available at:
#' <http://hermanaguinis.com/pubs.html>
#' 
#' @noRd
icc_beta_cpp <- function(X, l2id, T, vy) {
    .Call(`_iccbeta_icc_beta_cpp`, X, l2id, T, vy)
}

