% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mltools.R
\name{relative}
\alias{relative}
\title{Relative Numeric Representation}
\usage{
relative(x, order = FALSE, signif = 0.2, quietly)
}
\arguments{
\item{x}{an ichimoku object.}

\item{order}{[default FALSE] set to TRUE to order the results by the absolute
'z-score'.}

\item{signif}{[default 0.2] set a significance threshold for which if 'p' is
equal or lower, the element will be starred with a '*'.}

\item{quietly}{(optional) if set to TRUE, will suppress printing of additional
output to the console and return quietly.}
}
\value{
A data frame containing a statistical summary of the latest ichimoku
    cloud chart representation in relation to historical values.

    In addition, the time index of the latest observed values and total
    number of datapoints are printed to the console.
}
\description{
Produce a statistical summary of the latest numeric representation of the
    ichimoku cloud chart relative to historical values. For determining
    whether current trading falls within or outside of normal ranges.
}
\details{
'mean(X)' is the mean value for each element X, 'sd(X)' the
    standard deviation, and 'X[n]' the nth or latest observed values.

    'res' is the residual X[n] - mean(X) and represents a centred measure of
    deviation for the latest observed value.

    The 'z-score' (or standard score) is calculated as res / sd(X) and is a
    centred and scaled measure of deviation for the latest observed value.

    'p >= |z|' represents the empirical probability of the latest observed
    absolute 'z-score' or greater.

    'p*' will display a star if 'p >= |z|' is less than or equal to the value
    of the argument 'signif'.

    'E(|res|)|p' represents the mean or expected absolute value of 'res',
    conditional upon the absolute 'z-score' being greater than equal to the
    latest observed absolute 'z-score'.
}
\section{Further Details}{

    Please refer to the strategies vignette by calling:
    \code{vignette("strategies", package = "ichimoku")}
}

\examples{
cloud <- ichimoku(sample_ohlc_data, ticker = "TKR")
statistics <- relative(cloud, quietly = TRUE)
relative(cloud, signif = 0.4)
relative(cloud, order = TRUE, signif = 0.4)

}
